/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.FixedSizeCompressedObjectStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class CompressedLongBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<LongBuffer> {
    public static CompressedLongBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedLongBufferObjectStrategy(order, compression, sizePer);
    }

    private CompressedLongBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<LongBuffer>(){

            @Override
            public LongBuffer convert(ByteBuffer buf) {
                return buf.asLongBuffer();
            }

            @Override
            public int compare(LongBuffer lhs, LongBuffer rhs) {
                return Ordering.natural().nullsFirst().compare((Object)lhs, (Object)rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 8;
            }

            @Override
            public LongBuffer combine(ByteBuffer into, LongBuffer from) {
                return into.asLongBuffer().put(from);
            }
        }, compression, sizePer);
    }
}

