/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.FixedSizeCompressedObjectStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CompressedByteBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<ByteBuffer> {
    public static final Ordering<Comparable> ORDERING = Ordering.natural().nullsFirst();

    public static CompressedByteBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedByteBufferObjectStrategy(order, compression, sizePer);
    }

    public CompressedByteBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<ByteBuffer>(){

            @Override
            public ByteBuffer convert(ByteBuffer buf) {
                return buf;
            }

            @Override
            public int compare(ByteBuffer lhs, ByteBuffer rhs) {
                return ORDERING.compare((Object)lhs, (Object)rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count;
            }

            @Override
            public ByteBuffer combine(ByteBuffer into, ByteBuffer from) {
                return into.put(from);
            }
        }, compression, sizePer);
    }
}

