/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.primitives.Ints;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedFloatBufferObjectStrategy;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.FloatSupplierSerializer;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class BlockLayoutFloatSupplierSerializer
implements FloatSupplierSerializer {
    private final IOPeon ioPeon;
    private final int sizePer;
    private final GenericIndexedWriter<ResourceHolder<FloatBuffer>> flattener;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final String metaFile;
    private long metaCount = 0L;
    private int numInserted = 0;
    private FloatBuffer endBuffer;

    public BlockLayoutFloatSupplierSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) {
        this.ioPeon = ioPeon;
        this.sizePer = 16384;
        this.flattener = new GenericIndexedWriter<ResourceHolder<FloatBuffer>>(ioPeon, filenameBase, CompressedFloatBufferObjectStrategy.getBufferForOrder(order, compression, this.sizePer));
        this.metaFile = filenameBase + ".format";
        this.compression = compression;
        this.endBuffer = FloatBuffer.allocate(this.sizePer);
        this.endBuffer.mark();
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(float value) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write((ResourceHolder<FloatBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            this.endBuffer = FloatBuffer.allocate(this.sizePer);
            this.endBuffer.mark();
        }
        this.endBuffer.put(value);
        ++this.numInserted;
    }

    @Override
    public void closeAndConsolidate(ByteSink consolidatedOut) throws IOException {
        this.close();
        try (OutputStream out = consolidatedOut.openStream();
             InputStream meta = this.ioPeon.makeInputStream(this.metaFile);){
            ByteStreams.copy((InputStream)meta, (OutputStream)out);
            ByteStreams.copy(this.flattener.combineStreams(), (OutputStream)out);
        }
    }

    @Override
    public void close() throws IOException {
        this.endBuffer.limit(this.endBuffer.position());
        this.endBuffer.rewind();
        this.flattener.write((ResourceHolder<FloatBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
        this.endBuffer = null;
        this.flattener.close();
        try (CountingOutputStream metaOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.metaFile));){
            metaOut.write(2);
            metaOut.write(Ints.toByteArray((int)this.numInserted));
            metaOut.write(Ints.toByteArray((int)this.sizePer));
            metaOut.write((int)this.compression.getId());
            metaOut.close();
            this.metaCount = metaOut.getCount();
        }
    }

    @Override
    public long getSerializedSize() {
        return this.metaCount + this.flattener.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        try (InputStream meta = this.ioPeon.makeInputStream(this.metaFile);
             InputStream input = (InputStream)this.flattener.combineStreams().getInput();){
            ByteStreams.copy((ReadableByteChannel)Channels.newChannel(meta), (WritableByteChannel)channel);
            ReadableByteChannel from = Channels.newChannel(input);
            ByteStreams.copy((ReadableByteChannel)from, (WritableByteChannel)channel);
        }
    }
}

