/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import io.druid.segment.DimensionHandler;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.Metadata;
import io.druid.segment.Rowboat;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import java.util.Map;
import org.joda.time.Interval;

public class RowboatFilteringIndexAdapter
implements IndexableAdapter {
    private final IndexableAdapter baseAdapter;
    private final Predicate<Rowboat> filter;

    public RowboatFilteringIndexAdapter(IndexableAdapter baseAdapter, Predicate<Rowboat> filter) {
        this.baseAdapter = baseAdapter;
        this.filter = filter;
    }

    @Override
    public Interval getDataInterval() {
        return this.baseAdapter.getDataInterval();
    }

    @Override
    public int getNumRows() {
        return this.baseAdapter.getNumRows();
    }

    @Override
    public Indexed<String> getDimensionNames() {
        return this.baseAdapter.getDimensionNames();
    }

    @Override
    public Indexed<String> getMetricNames() {
        return this.baseAdapter.getMetricNames();
    }

    @Override
    public Indexed<Comparable> getDimValueLookup(String dimension) {
        return this.baseAdapter.getDimValueLookup(dimension);
    }

    @Override
    public Iterable<Rowboat> getRows() {
        return Iterables.filter(this.baseAdapter.getRows(), this.filter);
    }

    @Override
    public String getMetricType(String metric) {
        return this.baseAdapter.getMetricType(metric);
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.baseAdapter.getCapabilities(column);
    }

    @Override
    public IndexedInts getBitmapIndex(String dimension, int dictId) {
        return this.baseAdapter.getBitmapIndex(dimension, dictId);
    }

    @Override
    public Metadata getMetadata() {
        return this.baseAdapter.getMetadata();
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.baseAdapter.getDimensionHandlers();
    }
}

