/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import io.druid.collections.StupidPool;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.Filter;
import io.druid.query.topn.AggregateTopNMetricFirstAlgorithm;
import io.druid.query.topn.DimExtractionTopNAlgorithm;
import io.druid.query.topn.PooledTopNAlgorithm;
import io.druid.query.topn.TimeExtractionTopNAlgorithm;
import io.druid.query.topn.TopNAlgorithm;
import io.druid.query.topn.TopNAlgorithmSelector;
import io.druid.query.topn.TopNMapFn;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.SegmentMissingException;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.Filters;
import java.nio.ByteBuffer;
import java.util.List;
import org.joda.time.Interval;

public class TopNQueryEngine {
    private static final Logger log = new Logger(TopNQueryEngine.class);
    private final StupidPool<ByteBuffer> bufferPool;

    public TopNQueryEngine(StupidPool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    public Sequence<Result<TopNResultValue>> query(TopNQuery query, final StorageAdapter adapter) {
        if (adapter == null) {
            throw new SegmentMissingException("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> queryIntervals = query.getQuerySegmentSpec().getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        QueryGranularity granularity = query.getGranularity();
        final Function<Cursor, Result<TopNResultValue>> mapFn = this.getMapFn(query, adapter);
        Preconditions.checkArgument((queryIntervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{queryIntervals});
        return Sequences.filter((Sequence)Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), granularity, query.isDescending()), (Function)new Function<Cursor, Result<TopNResultValue>>(){

            public Result<TopNResultValue> apply(Cursor input) {
                log.debug("Running over cursor[%s]", new Object[]{adapter.getInterval(), input.getTime()});
                return (Result)mapFn.apply((Object)input);
            }
        }), (Predicate)Predicates.notNull());
    }

    private Function<Cursor, Result<TopNResultValue>> getMapFn(TopNQuery query, StorageAdapter adapter) {
        Capabilities capabilities = adapter.getCapabilities();
        String dimension = query.getDimensionSpec().getDimension();
        int cardinality = adapter.getDimensionCardinality(dimension);
        int numBytesPerRecord = 0;
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            numBytesPerRecord += aggregatorFactory.getMaxIntermediateSize();
        }
        TopNAlgorithmSelector selector = new TopNAlgorithmSelector(cardinality, numBytesPerRecord);
        query.initTopNAlgorithmSelector(selector);
        TopNAlgorithm<Aggregator[][], TopNParams> topNAlgorithm = selector.isHasExtractionFn() && dimension.equals("__time") ? new TimeExtractionTopNAlgorithm(capabilities, query) : (selector.isHasExtractionFn() ? new DimExtractionTopNAlgorithm(capabilities, query) : (selector.isAggregateAllMetrics() ? new PooledTopNAlgorithm(capabilities, query, this.bufferPool) : (selector.isAggregateTopNMetricFirst() || query.getContextBoolean("doAggregateTopNMetricFirst", false) ? new AggregateTopNMetricFirstAlgorithm(capabilities, query, this.bufferPool) : new PooledTopNAlgorithm(capabilities, query, this.bufferPool))));
        return new TopNMapFn(query, topNAlgorithm);
    }

    public static boolean canApplyExtractionInPost(TopNQuery query) {
        return query.getDimensionSpec() != null && query.getDimensionSpec().getExtractionFn() != null && ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)query.getDimensionSpec().getExtractionFn().getExtractionType()) && query.getTopNMetricSpec().canBeOptimizedUnordered();
    }
}

