/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.metamx.common.Pair;
import com.metamx.common.guava.CloseQuietly;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidPool;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.TopNMetricSpecBuilder;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class PooledTopNAlgorithm
extends BaseTopNAlgorithm<int[], BufferAggregator[], PooledTopNParams> {
    private final Capabilities capabilities;
    private final TopNQuery query;
    private final StupidPool<ByteBuffer> bufferPool;
    private static final int AGG_UNROLL_COUNT = 8;

    public PooledTopNAlgorithm(Capabilities capabilities, TopNQuery query, StupidPool<ByteBuffer> bufferPool) {
        super(capabilities);
        this.capabilities = capabilities;
        this.query = query;
        this.bufferPool = bufferPool;
    }

    @Override
    public PooledTopNParams makeInitParams(DimensionSelector dimSelector, Cursor cursor) {
        ResourceHolder resultsBufHolder = this.bufferPool.take();
        ByteBuffer resultsBuf = (ByteBuffer)resultsBufHolder.get();
        resultsBuf.clear();
        final int cardinality = dimSelector.getValueCardinality();
        if (cardinality < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with no dictionary");
        }
        BaseTopNAlgorithm.BaseArrayProvider<int[]> arrayProvider = new BaseTopNAlgorithm.BaseArrayProvider<int[]>(dimSelector, this.query, this.capabilities){
            private final int[] positions;
            {
                super(dimSelector, query, capabilities);
                this.positions = new int[cardinality];
            }

            @Override
            public int[] build() {
                Pair<Integer, Integer> startEnd = this.computeStartEnd(cardinality);
                Arrays.fill(this.positions, 0, (int)((Integer)startEnd.lhs), -2);
                Arrays.fill(this.positions, (int)((Integer)startEnd.lhs), (int)((Integer)startEnd.rhs), -1);
                Arrays.fill(this.positions, (int)((Integer)startEnd.rhs), this.positions.length, -2);
                return this.positions;
            }
        };
        int numBytesToWorkWith = resultsBuf.remaining();
        int[] aggregatorSizes = new int[this.query.getAggregatorSpecs().size()];
        int numBytesPerRecord = 0;
        for (int i = 0; i < this.query.getAggregatorSpecs().size(); ++i) {
            aggregatorSizes[i] = this.query.getAggregatorSpecs().get(i).getMaxIntermediateSize();
            numBytesPerRecord += aggregatorSizes[i];
        }
        int numValuesPerPass = numBytesPerRecord > 0 ? numBytesToWorkWith / numBytesPerRecord : cardinality;
        return PooledTopNParams.builder().withDimSelector(dimSelector).withCursor(cursor).withResultsBufHolder((ResourceHolder<ByteBuffer>)resultsBufHolder).withResultsBuf(resultsBuf).withArrayProvider((TopNMetricSpecBuilder<int[]>)arrayProvider).withNumBytesPerRecord(numBytesPerRecord).withNumValuesPerPass(numValuesPerPass).withAggregatorSizes(aggregatorSizes).build();
    }

    @Override
    protected int[] makeDimValSelector(PooledTopNParams params, int numProcessed, int numToProcess) {
        TopNMetricSpecBuilder<int[]> arrayProvider = params.getArrayProvider();
        if (!this.query.getDimensionSpec().preservesOrdering()) {
            return arrayProvider.build();
        }
        arrayProvider.ignoreFirstN(numProcessed);
        arrayProvider.keepOnlyN(numToProcess);
        return this.query.getTopNMetricSpec().configureOptimizer(arrayProvider).build();
    }

    @Override
    protected int computeNewLength(int[] dimValSelector, int numProcessed, int numToProcess) {
        int valid = 0;
        int length = 0;
        for (int i = numProcessed; i < dimValSelector.length && valid < numToProcess; ++i) {
            ++length;
            if (-2 == dimValSelector[i]) continue;
            ++valid;
        }
        return length;
    }

    @Override
    protected int[] updateDimValSelector(int[] dimValSelector, int numProcessed, int numToProcess) {
        int[] retVal = Arrays.copyOf(dimValSelector, dimValSelector.length);
        int validEnd = Math.min(retVal.length, numProcessed + numToProcess);
        int end = Math.max(retVal.length, validEnd);
        Arrays.fill(retVal, 0, numProcessed, -2);
        Arrays.fill(retVal, validEnd, end, -2);
        return retVal;
    }

    @Override
    protected BufferAggregator[] makeDimValAggregateStore(PooledTopNParams params) {
        return PooledTopNAlgorithm.makeBufferAggregators(params.getCursor(), this.query.getAggregatorSpecs());
    }

    @Override
    protected void scanAndAggregate(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators, int numProcessed) {
        ByteBuffer resultsBuf = params.getResultsBuf();
        int numBytesPerRecord = params.getNumBytesPerRecord();
        int[] aggregatorSizes = params.getAggregatorSizes();
        Cursor cursor = params.getCursor();
        DimensionSelector dimSelector = params.getDimSelector();
        int[] aggregatorOffsets = new int[aggregatorSizes.length];
        int offset = 0;
        for (int j = 0; j < aggregatorSizes.length; ++j) {
            aggregatorOffsets[j] = offset;
            offset += aggregatorSizes[j];
        }
        int aggSize = theAggregators.length;
        int aggExtra = aggSize % 8;
        AtomicInteger currentPosition = new AtomicInteger(0);
        while (!cursor.isDone()) {
            IndexedInts dimValues = dimSelector.getRow();
            int dimSize = dimValues.size();
            int dimExtra = dimSize % 8;
            switch (dimExtra) {
                case 7: {
                    PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(6), currentPosition);
                }
                case 6: {
                    PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(5), currentPosition);
                }
                case 5: {
                    PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(4), currentPosition);
                }
                case 4: {
                    PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(3), currentPosition);
                }
                case 3: {
                    PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(2), currentPosition);
                }
                case 2: {
                    PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(1), currentPosition);
                }
                case 1: {
                    PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(0), currentPosition);
                }
            }
            for (int i = dimExtra; i < dimSize; i += 8) {
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i), currentPosition);
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 1), currentPosition);
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 2), currentPosition);
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 3), currentPosition);
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 4), currentPosition);
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 5), currentPosition);
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 6), currentPosition);
                PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, numProcessed, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 7), currentPosition);
            }
            cursor.advance();
        }
    }

    private static void aggregateDimValue(int[] positions, BufferAggregator[] theAggregators, int numProcessed, ByteBuffer resultsBuf, int numBytesPerRecord, int[] aggregatorOffsets, int aggSize, int aggExtra, int dimIndex, AtomicInteger currentPosition) {
        int j;
        if (-2 == positions[dimIndex]) {
            return;
        }
        if (-1 == positions[dimIndex]) {
            positions[dimIndex] = currentPosition.getAndIncrement() * numBytesPerRecord;
            int pos = positions[dimIndex];
            for (j = 0; j < aggSize; ++j) {
                theAggregators[j].init(resultsBuf, pos + aggregatorOffsets[j]);
            }
        }
        int position = positions[dimIndex];
        switch (aggExtra) {
            case 7: {
                theAggregators[6].aggregate(resultsBuf, position + aggregatorOffsets[6]);
            }
            case 6: {
                theAggregators[5].aggregate(resultsBuf, position + aggregatorOffsets[5]);
            }
            case 5: {
                theAggregators[4].aggregate(resultsBuf, position + aggregatorOffsets[4]);
            }
            case 4: {
                theAggregators[3].aggregate(resultsBuf, position + aggregatorOffsets[3]);
            }
            case 3: {
                theAggregators[2].aggregate(resultsBuf, position + aggregatorOffsets[2]);
            }
            case 2: {
                theAggregators[1].aggregate(resultsBuf, position + aggregatorOffsets[1]);
            }
            case 1: {
                theAggregators[0].aggregate(resultsBuf, position + aggregatorOffsets[0]);
            }
        }
        for (j = aggExtra; j < aggSize; j += 8) {
            theAggregators[j].aggregate(resultsBuf, position + aggregatorOffsets[j]);
            theAggregators[j + 1].aggregate(resultsBuf, position + aggregatorOffsets[j + 1]);
            theAggregators[j + 2].aggregate(resultsBuf, position + aggregatorOffsets[j + 2]);
            theAggregators[j + 3].aggregate(resultsBuf, position + aggregatorOffsets[j + 3]);
            theAggregators[j + 4].aggregate(resultsBuf, position + aggregatorOffsets[j + 4]);
            theAggregators[j + 5].aggregate(resultsBuf, position + aggregatorOffsets[j + 5]);
            theAggregators[j + 6].aggregate(resultsBuf, position + aggregatorOffsets[j + 6]);
            theAggregators[j + 7].aggregate(resultsBuf, position + aggregatorOffsets[j + 7]);
        }
    }

    @Override
    protected void updateResults(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators, TopNResultBuilder resultBuilder) {
        ByteBuffer resultsBuf = params.getResultsBuf();
        int[] aggregatorSizes = params.getAggregatorSizes();
        DimensionSelector dimSelector = params.getDimSelector();
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i];
            if (position < 0) continue;
            Object[] vals = new Object[theAggregators.length];
            for (int j = 0; j < theAggregators.length; ++j) {
                vals[j] = theAggregators[j].get(resultsBuf, position);
                position += aggregatorSizes[j];
            }
            resultBuilder.addEntry(dimSelector.lookupName(i), i, vals);
        }
    }

    @Override
    protected void closeAggregators(BufferAggregator[] bufferAggregators) {
        for (BufferAggregator agg : bufferAggregators) {
            agg.close();
        }
    }

    @Override
    public void cleanup(PooledTopNParams params) {
        if (params != null) {
            ResourceHolder<ByteBuffer> resultsBufHolder = params.getResultsBufHolder();
            if (resultsBufHolder != null) {
                ((ByteBuffer)resultsBufHolder.get()).clear();
            }
            CloseQuietly.close(resultsBufHolder);
        }
    }

    public static class PooledTopNParams
    extends TopNParams {
        private final ResourceHolder<ByteBuffer> resultsBufHolder;
        private final ByteBuffer resultsBuf;
        private final int[] aggregatorSizes;
        private final int numBytesPerRecord;
        private final TopNMetricSpecBuilder<int[]> arrayProvider;

        public PooledTopNParams(DimensionSelector dimSelector, Cursor cursor, ResourceHolder<ByteBuffer> resultsBufHolder, ByteBuffer resultsBuf, int[] aggregatorSizes, int numBytesPerRecord, int numValuesPerPass, TopNMetricSpecBuilder<int[]> arrayProvider) {
            super(dimSelector, cursor, numValuesPerPass);
            this.resultsBufHolder = resultsBufHolder;
            this.resultsBuf = resultsBuf;
            this.aggregatorSizes = aggregatorSizes;
            this.numBytesPerRecord = numBytesPerRecord;
            this.arrayProvider = arrayProvider;
        }

        public static Builder builder() {
            return new Builder();
        }

        public ResourceHolder<ByteBuffer> getResultsBufHolder() {
            return this.resultsBufHolder;
        }

        public ByteBuffer getResultsBuf() {
            return this.resultsBuf;
        }

        public int[] getAggregatorSizes() {
            return this.aggregatorSizes;
        }

        public int getNumBytesPerRecord() {
            return this.numBytesPerRecord;
        }

        public TopNMetricSpecBuilder<int[]> getArrayProvider() {
            return this.arrayProvider;
        }

        public static class Builder {
            private DimensionSelector dimSelector = null;
            private Cursor cursor = null;
            private ResourceHolder<ByteBuffer> resultsBufHolder = null;
            private ByteBuffer resultsBuf = null;
            private int[] aggregatorSizes = null;
            private int numBytesPerRecord = 0;
            private int numValuesPerPass = 0;
            private TopNMetricSpecBuilder<int[]> arrayProvider = null;

            public Builder withDimSelector(DimensionSelector dimSelector) {
                this.dimSelector = dimSelector;
                return this;
            }

            public Builder withCursor(Cursor cursor) {
                this.cursor = cursor;
                return this;
            }

            public Builder withResultsBufHolder(ResourceHolder<ByteBuffer> resultsBufHolder) {
                this.resultsBufHolder = resultsBufHolder;
                return this;
            }

            public Builder withResultsBuf(ByteBuffer resultsBuf) {
                this.resultsBuf = resultsBuf;
                return this;
            }

            public Builder withAggregatorSizes(int[] aggregatorSizes) {
                this.aggregatorSizes = aggregatorSizes;
                return this;
            }

            public Builder withNumBytesPerRecord(int numBytesPerRecord) {
                this.numBytesPerRecord = numBytesPerRecord;
                return this;
            }

            public Builder withNumValuesPerPass(int numValuesPerPass) {
                this.numValuesPerPass = numValuesPerPass;
                return this;
            }

            public Builder withArrayProvider(TopNMetricSpecBuilder<int[]> arrayProvider) {
                this.arrayProvider = arrayProvider;
                return this;
            }

            public PooledTopNParams build() {
                return new PooledTopNParams(this.dimSelector, this.cursor, this.resultsBufHolder, this.resultsBuf, this.aggregatorSizes, this.numBytesPerRecord, this.numValuesPerPass, this.arrayProvider);
            }
        }
    }
}

