/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.orderby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.StringUtils;
import io.druid.query.ordering.StringComparator;
import io.druid.query.ordering.StringComparators;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OrderByColumnSpec {
    public static final StringComparator DEFAULT_DIMENSION_ORDER = StringComparators.LEXICOGRAPHIC;
    private final String dimension;
    private final Direction direction;
    private final StringComparator dimensionComparator;

    @JsonCreator
    public OrderByColumnSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="dimensionOrder") StringComparator dimensionComparator) {
        this.dimension = dimension;
        this.direction = direction == null ? Direction.ASCENDING : direction;
        this.dimensionComparator = dimensionComparator == null ? DEFAULT_DIMENSION_ORDER : dimensionComparator;
    }

    @JsonCreator
    public static OrderByColumnSpec fromString(String dimension) {
        return new OrderByColumnSpec(dimension, null, null);
    }

    public static OrderByColumnSpec asc(String dimension) {
        return new OrderByColumnSpec(dimension, Direction.ASCENDING, null);
    }

    public static List<OrderByColumnSpec> ascending(String ... dimension) {
        return Lists.transform(Arrays.asList(dimension), (Function)new Function<String, OrderByColumnSpec>(){

            public OrderByColumnSpec apply(@Nullable String input) {
                return OrderByColumnSpec.asc(input);
            }
        });
    }

    public static OrderByColumnSpec desc(String dimension) {
        return new OrderByColumnSpec(dimension, Direction.DESCENDING, null);
    }

    public static List<OrderByColumnSpec> descending(String ... dimension) {
        return Lists.transform(Arrays.asList(dimension), (Function)new Function<String, OrderByColumnSpec>(){

            public OrderByColumnSpec apply(@Nullable String input) {
                return OrderByColumnSpec.desc(input);
            }
        });
    }

    public OrderByColumnSpec(String dimension, Direction direction) {
        this(dimension, direction, null);
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty(value="direction")
    public Direction getDirection() {
        return this.direction;
    }

    @JsonProperty(value="dimensionOrder")
    public StringComparator getDimensionComparator() {
        return this.dimensionComparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderByColumnSpec that = (OrderByColumnSpec)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.dimensionComparator.equals(that.dimensionComparator)) {
            return false;
        }
        return this.direction == that.direction;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.dimensionComparator.hashCode();
        return result;
    }

    public String toString() {
        return "OrderByColumnSpec{dimension='" + this.dimension + '\'' + ", direction='" + (Object)((Object)this.direction) + '\'' + ", dimensionComparator='" + this.dimensionComparator + '\'' + '}';
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] directionBytes = StringUtils.toUtf8((String)this.direction.name());
        return ByteBuffer.allocate(dimensionBytes.length + directionBytes.length).put(dimensionBytes).put(directionBytes).array();
    }

    public static enum Direction {
        ASCENDING,
        DESCENDING;

        private static final Map<String, Direction> stupidEnumMap;

        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static Direction fromString(String name) {
            String upperName = name.toUpperCase();
            Direction direction = stupidEnumMap.get(upperName);
            if (direction == null) {
                for (Direction dir : Direction.values()) {
                    if (!dir.name().startsWith(upperName)) continue;
                    if (direction != null) {
                        throw new ISE("Ambiguous directions[%s] and [%s]", new Object[]{direction, dir});
                    }
                    direction = dir;
                }
            }
            return direction;
        }

        static {
            ImmutableMap.Builder bob = ImmutableMap.builder();
            for (Direction direction : Direction.values()) {
                bob.put((Object)direction.name(), (Object)direction);
            }
            stupidEnumMap = bob.build();
        }
    }
}

