/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.FilteredSequence;
import com.metamx.common.guava.Sequence;
import io.druid.collections.BlockingPool;
import io.druid.collections.ReferenceCountingResourceHolder;
import io.druid.data.input.Row;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import io.druid.query.groupby.epinephelinae.Grouper;
import io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import io.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.filter.Filters;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByRowProcessor {
    public static Sequence<Row> process(Query queryParam, Sequence<Row> rows, GroupByQueryConfig config, final BlockingPool<ByteBuffer> mergeBufferPool, final ObjectMapper spillMapper) {
        final GroupByQuery query = (GroupByQuery)queryParam;
        final GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        final AggregatorFactory[] aggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            aggregatorFactories[i] = query.getAggregatorSpecs().get(i);
        }
        final File temporaryStorageDirectory = new File(System.getProperty("java.io.tmpdir"), String.format("druid-groupBy-%s_%s", UUID.randomUUID(), query.getId()));
        Number queryTimeout = query.getContextValue("timeout", null);
        final long timeout = queryTimeout == null ? 0x3FFFFFFFFFFFFFFFL : queryTimeout.longValue();
        final List<Interval> queryIntervals = query.getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimFilter()));
        final RowBasedValueMatcherFactory filterMatcherFactory = new RowBasedValueMatcherFactory();
        final ValueMatcher filterMatcher = filter == null ? new BooleanValueMatcher(true) : filter.makeMatcher(filterMatcherFactory);
        final FilteredSequence filteredSequence = new FilteredSequence(rows, (Predicate)new Predicate<Row>(){

            public boolean apply(Row input) {
                boolean inInterval = false;
                DateTime rowTime = input.getTimestamp();
                for (Interval queryInterval : queryIntervals) {
                    if (!queryInterval.contains((ReadableInstant)rowTime)) continue;
                    inInterval = true;
                }
                if (!inInterval) {
                    return false;
                }
                filterMatcherFactory.setRow(input);
                return filterMatcher.matches();
            }
        });
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(){

            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                ArrayList closeOnFailure = Lists.newArrayList();
                try {
                    ReferenceCountingResourceHolder mergeBufferHolder;
                    final LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    closeOnFailure.add(temporaryStorage);
                    try {
                        if (timeout <= 0L || (mergeBufferHolder = mergeBufferPool.take(timeout)) == null) {
                            throw new QueryInterruptedException(new TimeoutException());
                        }
                        closeOnFailure.add(mergeBufferHolder);
                    }
                    catch (InterruptedException e) {
                        throw new QueryInterruptedException(e);
                    }
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<Grouper<RowBasedGrouperHelper.RowBasedKey>, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, true, querySpecificConfig, (ByteBuffer)mergeBufferHolder.get(), -1, temporaryStorage, spillMapper, aggregatorFactories);
                    final Grouper grouper = (Grouper)pair.lhs;
                    Accumulator accumulator = (Accumulator)pair.rhs;
                    closeOnFailure.add(grouper);
                    Grouper retVal = (Grouper)filteredSequence.accumulate((Object)grouper, accumulator);
                    if (retVal != grouper) {
                        throw new ResourceLimitExceededException("Grouping resources exhausted");
                    }
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            grouper.close();
                            mergeBufferHolder.close();
                            CloseQuietly.close((Closeable)temporaryStorage);
                        }
                    });
                }
                catch (Throwable e) {
                    for (Closeable closeable : Lists.reverse((List)closeOnFailure)) {
                        CloseQuietly.close((Closeable)closeable);
                    }
                    throw e;
                }
            }

            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    private static class RowBasedValueMatcherFactory
    implements ValueMatcherFactory {
        private Row row;

        private RowBasedValueMatcherFactory() {
        }

        public void setRow(Row row) {
            this.row = row;
        }

        @Override
        public ValueMatcher makeValueMatcher(final String dimension, final Comparable value) {
            if (dimension.equals("__time")) {
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        return value.equals(RowBasedValueMatcherFactory.this.row.getTimestampFromEpoch());
                    }
                };
            }
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    return RowBasedValueMatcherFactory.this.row.getDimension(dimension).contains(value);
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(final String dimension, final DruidPredicateFactory predicateFactory) {
            if (dimension.equals("__time")) {
                return new ValueMatcher(){
                    final DruidLongPredicate predicate;
                    {
                        this.predicate = predicateFactory.makeLongPredicate();
                    }

                    @Override
                    public boolean matches() {
                        return this.predicate.applyLong(RowBasedValueMatcherFactory.this.row.getTimestampFromEpoch());
                    }
                };
            }
            return new ValueMatcher(){
                final Predicate<String> predicate;
                {
                    this.predicate = predicateFactory.makeStringPredicate();
                }

                @Override
                public boolean matches() {
                    List values = RowBasedValueMatcherFactory.this.row.getDimension(dimension);
                    for (String value : values) {
                        if (!this.predicate.apply((Object)value)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

