/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.AccessLog;
import com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings;
import com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        LoadBalancerAttributes loadBalancerAttributesLoadBalancerAttributes;
        if (modifyLoadBalancerAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyLoadBalancerAttributesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2012-06-01");
        if (modifyLoadBalancerAttributesRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)modifyLoadBalancerAttributesRequest.getLoadBalancerName()));
        }
        if ((loadBalancerAttributesLoadBalancerAttributes = modifyLoadBalancerAttributesRequest.getLoadBalancerAttributes()) != null) {
            ConnectionSettings connectionSettingsConnectionSettings;
            ConnectionDraining connectionDrainingConnectionDraining;
            AccessLog accessLogAccessLog;
            CrossZoneLoadBalancing crossZoneLoadBalancingCrossZoneLoadBalancing = loadBalancerAttributesLoadBalancerAttributes.getCrossZoneLoadBalancing();
            if (crossZoneLoadBalancingCrossZoneLoadBalancing != null && crossZoneLoadBalancingCrossZoneLoadBalancing.isEnabled() != null) {
                request.addParameter("LoadBalancerAttributes.CrossZoneLoadBalancing.Enabled", StringUtils.fromBoolean((Boolean)crossZoneLoadBalancingCrossZoneLoadBalancing.isEnabled()));
            }
            if ((accessLogAccessLog = loadBalancerAttributesLoadBalancerAttributes.getAccessLog()) != null) {
                if (accessLogAccessLog.isEnabled() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.Enabled", StringUtils.fromBoolean((Boolean)accessLogAccessLog.isEnabled()));
                }
                if (accessLogAccessLog.getS3BucketName() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketName", StringUtils.fromString((String)accessLogAccessLog.getS3BucketName()));
                }
                if (accessLogAccessLog.getEmitInterval() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.EmitInterval", StringUtils.fromInteger((Integer)accessLogAccessLog.getEmitInterval()));
                }
                if (accessLogAccessLog.getS3BucketPrefix() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketPrefix", StringUtils.fromString((String)accessLogAccessLog.getS3BucketPrefix()));
                }
            }
            if ((connectionDrainingConnectionDraining = loadBalancerAttributesLoadBalancerAttributes.getConnectionDraining()) != null) {
                if (connectionDrainingConnectionDraining.isEnabled() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Enabled", StringUtils.fromBoolean((Boolean)connectionDrainingConnectionDraining.isEnabled()));
                }
                if (connectionDrainingConnectionDraining.getTimeout() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Timeout", StringUtils.fromInteger((Integer)connectionDrainingConnectionDraining.getTimeout()));
                }
            }
            if ((connectionSettingsConnectionSettings = loadBalancerAttributesLoadBalancerAttributes.getConnectionSettings()) != null && connectionSettingsConnectionSettings.getIdleTimeout() != null) {
                request.addParameter("LoadBalancerAttributes.ConnectionSettings.IdleTimeout", StringUtils.fromInteger((Integer)connectionSettingsConnectionSettings.getIdleTimeout()));
            }
            List<AdditionalAttribute> additionalAttributesList = loadBalancerAttributesLoadBalancerAttributes.getAdditionalAttributes();
            int additionalAttributesListIndex = 1;
            for (AdditionalAttribute additionalAttributesListValue : additionalAttributesList) {
                AdditionalAttribute additionalAttributeMember = additionalAttributesListValue;
                if (additionalAttributeMember != null) {
                    if (additionalAttributeMember.getKey() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Key", StringUtils.fromString((String)additionalAttributeMember.getKey()));
                    }
                    if (additionalAttributeMember.getValue() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Value", StringUtils.fromString((String)additionalAttributeMember.getValue()));
                    }
                }
                ++additionalAttributesListIndex;
            }
        }
        return request;
    }
}

