/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.tranquility.kafka.writer;

import com.google.common.primitives.Ints;
import com.metamx.common.logger.Logger;
import com.metamx.common.scala.net.curator.Disco;
import com.metamx.common.scala.net.curator.DiscoConfig;
import com.metamx.tranquility.config.DataSourceConfig;
import com.metamx.tranquility.finagle.FinagleRegistry;
import com.metamx.tranquility.finagle.FinagleRegistryConfig;
import com.metamx.tranquility.kafka.model.MessageCounters;
import com.metamx.tranquility.kafka.model.PropertiesBasedKafkaConfig;
import com.metamx.tranquility.kafka.writer.TranquilityEventWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class WriterController {
    private static final Logger log = new Logger(WriterController.class);
    private static final RetryPolicy RETRY_POLICY = new ExponentialBackoffRetry(1000, 500, 30000);
    private List<DataSourceConfig<PropertiesBasedKafkaConfig>> dataSourceConfigList;
    private Map<String, TranquilityEventWriter> writers = new ConcurrentHashMap<String, TranquilityEventWriter>();
    private Map<String, CuratorFramework> curators = new ConcurrentHashMap<String, CuratorFramework>();
    private Map<String, FinagleRegistry> finagleRegistries = new ConcurrentHashMap<String, FinagleRegistry>();

    public WriterController(Map<String, DataSourceConfig<PropertiesBasedKafkaConfig>> map) {
        this.dataSourceConfigList = new ArrayList<DataSourceConfig<PropertiesBasedKafkaConfig>>(map.values());
        Collections.sort(this.dataSourceConfigList, new Comparator<DataSourceConfig<PropertiesBasedKafkaConfig>>(){

            @Override
            public int compare(DataSourceConfig<PropertiesBasedKafkaConfig> dataSourceConfig, DataSourceConfig<PropertiesBasedKafkaConfig> dataSourceConfig2) {
                return ((PropertiesBasedKafkaConfig)dataSourceConfig2.propertiesBasedConfig()).getTopicPatternPriority().compareTo(((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).getTopicPatternPriority());
            }
        });
        log.info("Ready: [topicPattern] -> dataSource mappings:", new Object[0]);
        for (DataSourceConfig<PropertiesBasedKafkaConfig> dataSourceConfig : this.dataSourceConfigList) {
            log.info("  [%s] -> %s (priority: %d)", new Object[]{((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).getTopicPattern(), dataSourceConfig.dataSource(), ((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).getTopicPatternPriority()});
        }
    }

    public synchronized TranquilityEventWriter getWriter(String string) {
        if (!this.writers.containsKey(string)) {
            for (DataSourceConfig<PropertiesBasedKafkaConfig> dataSourceConfig : this.dataSourceConfigList) {
                if (!Pattern.matches(((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).getTopicPattern(), string)) continue;
                log.info("Creating EventWriter for topic [%s] using dataSource [%s]", new Object[]{string, dataSourceConfig.dataSource()});
                this.writers.put(string, this.createWriter(string, dataSourceConfig));
                return this.writers.get(string);
            }
            throw new RuntimeException(String.format("Kafka topicFilter allowed topic [%s] but no spec is mapped", string));
        }
        return this.writers.get(string);
    }

    public Map<String, MessageCounters> flushAll() throws InterruptedException {
        HashMap<String, MessageCounters> hashMap = new HashMap<String, MessageCounters>();
        for (Map.Entry<String, TranquilityEventWriter> entry : this.writers.entrySet()) {
            entry.getValue().flush();
            hashMap.put(entry.getKey(), entry.getValue().getMessageCounters());
        }
        return hashMap;
    }

    public void stop() {
        for (Map.Entry<String, TranquilityEventWriter> entry : this.writers.entrySet()) {
            entry.getValue().stop();
        }
        for (Map.Entry<String, TranquilityEventWriter> entry : this.curators.entrySet()) {
            ((CuratorFramework)entry.getValue()).close();
        }
    }

    protected TranquilityEventWriter createWriter(String string, DataSourceConfig<PropertiesBasedKafkaConfig> dataSourceConfig) {
        String string2;
        String string3 = ((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).zookeeperConnect();
        if (!this.curators.containsKey(string3)) {
            int n = Ints.checkedCast((long)((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).zookeeperTimeout().toStandardDuration().getMillis());
            CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).zookeeperConnect()).connectionTimeoutMs(n).retryPolicy(RETRY_POLICY).build();
            curatorFramework.start();
            this.curators.put(string3, curatorFramework);
        }
        if (!this.finagleRegistries.containsKey(string2 = String.format("%s:%s", string3, ((PropertiesBasedKafkaConfig)dataSourceConfig.propertiesBasedConfig()).discoPath()))) {
            this.finagleRegistries.put(string2, new FinagleRegistry(FinagleRegistryConfig.builder().build(), new Disco(this.curators.get(string3), (DiscoConfig)dataSourceConfig.propertiesBasedConfig())));
        }
        return new TranquilityEventWriter(string, dataSourceConfig, this.curators.get(string3), this.finagleRegistries.get(string2));
    }
}

