/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.tranquility.kafka.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParseException;
import com.metamx.tranquility.config.DataSourceConfig;
import com.metamx.tranquility.finagle.FinagleRegistry;
import com.metamx.tranquility.kafka.KafkaBeamUtils;
import com.metamx.tranquility.kafka.model.MessageCounters;
import com.metamx.tranquility.kafka.model.PropertiesBasedKafkaConfig;
import com.metamx.tranquility.tranquilizer.MessageDroppedException;
import com.metamx.tranquility.tranquilizer.Tranquilizer;
import com.twitter.util.FutureEventListener;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import scala.runtime.BoxedUnit;

public class TranquilityEventWriter {
    private static final Logger log = new Logger(TranquilityEventWriter.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final DataSourceConfig<PropertiesBasedKafkaConfig> dataSourceConfig;
    private final Tranquilizer<byte[]> tranquilizer;
    private final AtomicLong receivedCounter = new AtomicLong();
    private final AtomicLong sentCounter = new AtomicLong();
    private final AtomicLong droppedCounter = new AtomicLong();
    private final AtomicLong unparseableCounter = new AtomicLong();
    private final AtomicReference<Throwable> exception = new AtomicReference();

    public TranquilityEventWriter(String string, DataSourceConfig<PropertiesBasedKafkaConfig> dataSourceConfig, CuratorFramework curatorFramework, FinagleRegistry finagleRegistry) {
        this.dataSourceConfig = dataSourceConfig;
        this.tranquilizer = KafkaBeamUtils.createTranquilizer(string, dataSourceConfig, curatorFramework, finagleRegistry);
        this.tranquilizer.start();
    }

    public void send(byte[] byArray) throws InterruptedException {
        this.receivedCounter.incrementAndGet();
        this.tranquilizer.send((Object)byArray).addEventListener((FutureEventListener)new FutureEventListener<BoxedUnit>(){

            public void onSuccess(BoxedUnit boxedUnit) {
                TranquilityEventWriter.this.sentCounter.incrementAndGet();
            }

            public void onFailure(Throwable throwable) {
                if (throwable instanceof MessageDroppedException) {
                    TranquilityEventWriter.this.droppedCounter.incrementAndGet();
                    if (!((PropertiesBasedKafkaConfig)TranquilityEventWriter.this.dataSourceConfig.propertiesBasedConfig()).reportDropsAsExceptions().booleanValue()) {
                        return;
                    }
                } else if (throwable instanceof ParseException) {
                    TranquilityEventWriter.this.unparseableCounter.incrementAndGet();
                    if (!((PropertiesBasedKafkaConfig)TranquilityEventWriter.this.dataSourceConfig.propertiesBasedConfig()).reportParseExceptions().booleanValue()) {
                        return;
                    }
                }
                TranquilityEventWriter.this.exception.compareAndSet(null, throwable);
            }
        });
        this.maybeThrow();
    }

    public void flush() throws InterruptedException {
        this.tranquilizer.flush();
        this.maybeThrow();
    }

    public void stop() {
        try {
            this.tranquilizer.stop();
        }
        catch (IllegalStateException illegalStateException) {
            log.info((Throwable)illegalStateException, "Exception while stopping Tranquility", new Object[0]);
        }
    }

    public MessageCounters getMessageCounters() {
        return new MessageCounters(this.receivedCounter.get(), this.sentCounter.get(), this.droppedCounter.get(), this.unparseableCounter.get());
    }

    private void maybeThrow() {
        Throwable throwable = this.exception.get();
        if (throwable != null) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }
}

