/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.tranquility.kafka;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.metamx.common.logger.Logger;
import com.metamx.tranquility.config.DataSourceConfig;
import com.metamx.tranquility.config.TranquilityConfig;
import com.metamx.tranquility.kafka.KafkaConsumer;
import com.metamx.tranquility.kafka.model.PropertiesBasedKafkaConfig;
import com.metamx.tranquility.kafka.writer.WriterController;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import io.airlift.airline.SingleCommand;
import io.airlift.airline.model.CommandMetadata;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;

@Command(name="tranquility-kafka", description="Kafka consumer which pushes events to Druid through Tranquility")
public class KafkaMain {
    private static final Logger log = new Logger(KafkaMain.class);
    @Inject
    public HelpOption helpOption;
    @Option(name={"-f", "-configFile"}, description="Path to configuration property file")
    public String propertiesFile;

    public static void main(String[] stringArray) throws Exception {
        KafkaMain kafkaMain;
        try {
            kafkaMain = (KafkaMain)SingleCommand.singleCommand(KafkaMain.class).parse(stringArray);
        }
        catch (Exception exception) {
            log.error((Throwable)exception, "Exception parsing arguments", new Object[0]);
            Help.help((CommandMetadata)SingleCommand.singleCommand(KafkaMain.class).getCommandMetadata());
            return;
        }
        if (kafkaMain.helpOption.showHelpIfRequested()) {
            return;
        }
        kafkaMain.run();
    }

    public void run() throws InterruptedException {
        Object object222;
        Serializable serializable;
        Object object3;
        if (this.propertiesFile == null || this.propertiesFile.isEmpty()) {
            this.helpOption.help = true;
            this.helpOption.showHelpIfRequested();
            log.warn("Missing required parameters, aborting.", new Object[0]);
            return;
        }
        TranquilityConfig tranquilityConfig = null;
        try {
            object3 = new FileInputStream(this.propertiesFile);
            serializable = null;
            try {
                tranquilityConfig = TranquilityConfig.read((InputStream)object3, PropertiesBasedKafkaConfig.class);
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (serializable != null) {
                        try {
                            ((InputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object3).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            log.error("Could not read config file: %s, aborting.", new Object[]{this.propertiesFile});
            Throwables.propagate((Throwable)iOException);
        }
        object3 = (PropertiesBasedKafkaConfig)tranquilityConfig.globalConfig();
        serializable = Maps.newHashMap();
        for (Object object222 : tranquilityConfig.getDataSources()) {
            serializable.put(object222, tranquilityConfig.getDataSource((String)object222));
        }
        Properties properties = new Properties();
        for (String object4 : ((PropertiesBasedKafkaConfig)tranquilityConfig.globalConfig()).properties().stringPropertyNames()) {
            if (!object4.startsWith("kafka.")) continue;
            properties.setProperty(object4.replaceFirst("kafka\\.", ""), ((PropertiesBasedKafkaConfig)tranquilityConfig.globalConfig()).properties().getProperty(object4));
        }
        properties.setProperty("group.id", ((PropertiesBasedKafkaConfig)((Object)object3)).getKafkaGroupId());
        properties.setProperty("zookeeper.connect", ((PropertiesBasedKafkaConfig)((Object)object3)).getKafkaZookeeperConnect());
        if (properties.setProperty("zookeeper.session.timeout.ms", Long.toString(object3.zookeeperTimeout().toStandardDuration().getMillis())) != null) {
            throw new IllegalArgumentException("Set zookeeper.timeout instead of setting kafka.zookeeper.session.timeout.ms");
        }
        object222 = new WriterController((Map<String, DataSourceConfig<PropertiesBasedKafkaConfig>>)((Object)serializable));
        final KafkaConsumer kafkaConsumer = new KafkaConsumer((PropertiesBasedKafkaConfig)((Object)object3), properties, (Map<String, DataSourceConfig<PropertiesBasedKafkaConfig>>)((Object)serializable), (WriterController)object222);
        try {
            kafkaConsumer.start();
        }
        catch (Throwable throwable) {
            log.error(throwable, "Error while starting up. Exiting.", new Object[0]);
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("Initiating shutdown...", new Object[0]);
                kafkaConsumer.stop();
            }
        }));
        kafkaConsumer.join();
    }
}

