/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.machinelearning.model.RDSDataSpec;
import com.amazonaws.services.machinelearning.model.transform.RDSDatabaseCredentialsJsonMarshaller;
import com.amazonaws.services.machinelearning.model.transform.RDSDatabaseJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RDSDataSpecJsonMarshaller {
    private static RDSDataSpecJsonMarshaller instance;

    public void marshall(RDSDataSpec rDSDataSpec, JSONWriter jsonWriter) {
        if (rDSDataSpec == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList securityGroupIdsList;
            jsonWriter.object();
            if (rDSDataSpec.getDatabaseInformation() != null) {
                jsonWriter.key("DatabaseInformation");
                RDSDatabaseJsonMarshaller.getInstance().marshall(rDSDataSpec.getDatabaseInformation(), jsonWriter);
            }
            if (rDSDataSpec.getSelectSqlQuery() != null) {
                jsonWriter.key("SelectSqlQuery").value((Object)rDSDataSpec.getSelectSqlQuery());
            }
            if (rDSDataSpec.getDatabaseCredentials() != null) {
                jsonWriter.key("DatabaseCredentials");
                RDSDatabaseCredentialsJsonMarshaller.getInstance().marshall(rDSDataSpec.getDatabaseCredentials(), jsonWriter);
            }
            if (rDSDataSpec.getS3StagingLocation() != null) {
                jsonWriter.key("S3StagingLocation").value((Object)rDSDataSpec.getS3StagingLocation());
            }
            if (rDSDataSpec.getDataRearrangement() != null) {
                jsonWriter.key("DataRearrangement").value((Object)rDSDataSpec.getDataRearrangement());
            }
            if (rDSDataSpec.getDataSchema() != null) {
                jsonWriter.key("DataSchema").value((Object)rDSDataSpec.getDataSchema());
            }
            if (rDSDataSpec.getDataSchemaUri() != null) {
                jsonWriter.key("DataSchemaUri").value((Object)rDSDataSpec.getDataSchemaUri());
            }
            if (rDSDataSpec.getResourceRole() != null) {
                jsonWriter.key("ResourceRole").value((Object)rDSDataSpec.getResourceRole());
            }
            if (rDSDataSpec.getServiceRole() != null) {
                jsonWriter.key("ServiceRole").value((Object)rDSDataSpec.getServiceRole());
            }
            if (rDSDataSpec.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value((Object)rDSDataSpec.getSubnetId());
            }
            if (!(securityGroupIdsList = (SdkInternalList)rDSDataSpec.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
                jsonWriter.key("SecurityGroupIds");
                jsonWriter.array();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonWriter.value((Object)securityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RDSDataSpecJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RDSDataSpecJsonMarshaller();
        }
        return instance;
    }
}

