/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import io.druid.common.aws.AWSCredentialsConfig;
import io.druid.common.aws.FileSessionCredentialsProvider;

public class LazyFileSessionCredentialsProvider
implements AWSCredentialsProvider {
    private AWSCredentialsConfig config;
    private FileSessionCredentialsProvider provider;

    public LazyFileSessionCredentialsProvider(AWSCredentialsConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSessionCredentialsProvider getUnderlyingProvider() {
        if (this.provider == null) {
            AWSCredentialsConfig aWSCredentialsConfig = this.config;
            synchronized (aWSCredentialsConfig) {
                if (this.provider == null) {
                    this.provider = new FileSessionCredentialsProvider(this.config.getFileSessionCredentials());
                }
            }
        }
        return this.provider;
    }

    public AWSCredentials getCredentials() {
        return this.getUnderlyingProvider().getCredentials();
    }

    public void refresh() {
        this.getUnderlyingProvider().refresh();
    }
}

