/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.state;

import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCServer;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.domain.UnmodifiableIRCChannel;
import com.ircclouds.irc.api.state.IIRCState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IRCStateImpl
implements IIRCState {
    private String nickname;
    private String ident;
    private String realname;
    private IRCServer ircServer;
    private IRCServerOptions serverOptions;
    private List<IRCChannel> channels = new ArrayList<IRCChannel>();
    private List<String> altNicks;
    private boolean isConnected;
    private IRCStateImpl previousState;

    IRCStateImpl(String aIdent, String aRealname, List<String> aAltNicks, IRCServer aIRCServer, IRCServerOptions aServerOptions) {
        this.ident = aIdent;
        this.realname = aRealname;
        this.ircServer = aIRCServer;
        this.serverOptions = aServerOptions;
        this.altNicks = aAltNicks;
    }

    public IRCStateImpl(String aNickname, String aIdent, String aRealname, List<String> aAltNicks, IRCServer aIRCServer, IRCServerOptions aServerOptions) {
        this.nickname = aNickname;
        this.ident = aIdent;
        this.realname = aRealname;
        this.ircServer = aIRCServer;
        this.serverOptions = aServerOptions;
        this.altNicks = aAltNicks;
        this.previousState = new IRCStateImpl(aIdent, aRealname, aAltNicks, aIRCServer, aServerOptions);
        this.previousState.updateNick(this.nickname);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public List<String> getAltNicks() {
        return Collections.unmodifiableList(this.altNicks);
    }

    @Override
    public String getRealname() {
        return this.realname;
    }

    @Override
    public String getIdent() {
        return this.ident;
    }

    void updateNick(String aNickname) {
        this.nickname = aNickname;
    }

    List<IRCChannel> getChannelsMutable() {
        return this.channels;
    }

    IRCChannel getChannelByNameMutable(String aChannelName) {
        return this.getChannelByNameGeneric(aChannelName, new GetChannelCallback(){

            @Override
            public IRCChannel onReady(IRCChannel aChan) {
                return aChan;
            }
        });
    }

    @Override
    public IRCServer getServer() {
        return this.ircServer;
    }

    @Override
    public List<IRCChannel> getChannels() {
        ArrayList<UnmodifiableIRCChannel> _ircChannels = new ArrayList<UnmodifiableIRCChannel>();
        for (IRCChannel _c : this.channels) {
            _ircChannels.add(new UnmodifiableIRCChannel(_c));
        }
        return Collections.unmodifiableList(_ircChannels);
    }

    @Override
    public IRCChannel getChannelByName(String aChannelName) {
        return this.getChannelByNameGeneric(aChannelName, new GetChannelCallback(){

            @Override
            public IRCChannel onReady(IRCChannel aChan) {
                return new UnmodifiableIRCChannel(aChan);
            }
        });
    }

    @Override
    public IRCServerOptions getServerOptions() {
        return this.serverOptions;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean aIsConnected) {
        this.isConnected = aIsConnected;
    }

    private IRCChannel getChannelByNameGeneric(String aChannelName, GetChannelCallback aCallback) {
        for (IRCChannel _c : this.channels) {
            if (!_c.getName().equalsIgnoreCase(aChannelName)) continue;
            return aCallback.onReady(_c);
        }
        return null;
    }

    @Override
    public IIRCState getPrevious() {
        return this.previousState;
    }

    private static interface GetChannelCallback {
        public IRCChannel onReady(IRCChannel var1);
    }
}

