/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.state;

import com.ircclouds.irc.api.domain.ChannelMode;
import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCUser;
import com.ircclouds.irc.api.domain.IRCUserStatus;
import com.ircclouds.irc.api.domain.IRCUserStatusMode;
import com.ircclouds.irc.api.domain.IRCUserStatuses;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ChanPartMessage;
import com.ircclouds.irc.api.domain.messages.ChannelKick;
import com.ircclouds.irc.api.domain.messages.ChannelModeMessage;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.TopicMessage;
import com.ircclouds.irc.api.domain.messages.interfaces.IUserMessage;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import com.ircclouds.irc.api.state.IRCStateImpl;
import com.ircclouds.irc.api.state.IStateAccessor;
import com.ircclouds.irc.api.utils.StateUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractIRCStateUpdater
extends VariousMessageListenerAdapter
implements IStateAccessor {
    @Override
    public void onChannelJoin(ChanJoinMessage aMsg) {
        if (!this.isForMe(aMsg)) {
            IRCUser _user = aMsg.getSource();
            IRCChannel _chan = this.getIRCStateImpl().getChannelByNameMutable(aMsg.getChannelName());
            this.savedOldState(_chan);
            _chan.addUser(_user, new HashSet<IRCUserStatus>());
        }
    }

    @Override
    public void onChannelPart(ChanPartMessage aMsg) {
        if (!this.isForMe(aMsg)) {
            IRCChannel _chan = this.getIRCStateImpl().getChannelByNameMutable(aMsg.getChannelName());
            this.savedOldState(_chan);
            _chan.removeUser(aMsg.getSource());
        }
    }

    @Override
    public void onNickChange(NickMessage aMsg) {
        IRCUser _old = new IRCUser(aMsg.getSource().getNick());
        IRCUser _new = new IRCUser(aMsg.getNewNick());
        for (IRCChannel _chan : this.getIRCStateImpl().getChannelsMutable()) {
            this.savedOldState(_chan);
            if (!_chan.getUsers().containsKey(_old)) continue;
            _chan.addUser(_new, _chan.removeUser(_old));
        }
    }

    @Override
    public void onUserQuit(QuitMessage aMsg) {
        for (IRCChannel _chan : this.getIRCStateImpl().getChannelsMutable()) {
            this.savedOldState(_chan);
            _chan.removeUser(aMsg.getSource());
        }
    }

    @Override
    public void onTopicChange(TopicMessage aMsg) {
        IRCChannel _chan = this.getIRCStateImpl().getChannelByNameMutable(aMsg.getChannelName());
        this.savedOldState(_chan);
        _chan.setTopic(aMsg.getTopic());
    }

    @Override
    public void onChannelKick(ChannelKick aMsg) {
        IRCChannel _chan = this.getIRCStateImpl().getChannelByNameMutable(aMsg.getChannelName());
        this.savedOldState(_chan);
        _chan.removeUser(new IRCUser(aMsg.getKickedUser()));
    }

    @Override
    public void onChannelMode(ChannelModeMessage aMsg) {
        IRCUserStatus _us;
        IRCUserStatusMode _usm;
        String _chanName = aMsg.getChannelName();
        IRCChannel _chan = this.getIRCStateImpl().getChannelByNameMutable(_chanName);
        this.savedOldState(_chan);
        Map<IRCUser, Set<IRCUserStatus>> _users = _chan.getUsers();
        for (ChannelMode _mode : aMsg.getAddedModes()) {
            if (!(_mode instanceof IRCUserStatusMode)) continue;
            if (aMsg.getRemovedModes().contains(_mode)) {
                aMsg.getRemovedModes().remove(_mode);
                continue;
            }
            _usm = (IRCUserStatusMode)_mode;
            _us = this.getAvailableUserStatuses().getUserStatus(_usm.getChannelModeType());
            if (_us == null) continue;
            _users.get(new IRCUser(_usm.getUser())).add(_us);
        }
        for (ChannelMode _mode : aMsg.getRemovedModes()) {
            if (!(_mode instanceof IRCUserStatusMode)) continue;
            _usm = (IRCUserStatusMode)_mode;
            _us = this.getAvailableUserStatuses().getUserStatus(_usm.getChannelModeType());
            if (_us == null) continue;
            _users.get(new IRCUser(_usm.getUser())).remove(_us);
        }
    }

    private IRCStateImpl getIRCStateImpl() {
        return (IRCStateImpl)this.getIRCState();
    }

    private IRCStateImpl getPreviousIRCStateImpl() {
        return (IRCStateImpl)this.getIRCStateImpl().getPrevious();
    }

    private IRCUserStatuses getAvailableUserStatuses() {
        return this.getIRCState().getServerOptions().getUserChanStatuses();
    }

    private boolean isForMe(IUserMessage aMsg) {
        return this.getIRCState().getNickname().equals(aMsg.getSource().getNick());
    }

    @Override
    public void saveChan(IRCChannel aChannel) {
        this.getIRCStateImpl().getChannelsMutable().add(aChannel);
    }

    @Override
    public void deleteChan(String aChannelName) {
        this.getIRCStateImpl().getChannelsMutable().remove(aChannelName);
    }

    @Override
    public void updateNick(String aNewNick) {
        this.getIRCStateImpl().updateNick(aNewNick);
    }

    @Override
    public void deleteNickFromChan(String aChannel, String aNick) {
        for (IRCChannel _chan : this.getIRCStateImpl().getChannelsMutable()) {
            if (!_chan.getName().equals(aChannel)) continue;
            _chan.getUsers().remove(new IRCUser(aNick));
            break;
        }
    }

    private void savedOldState(IRCChannel aChan) {
        this.getPreviousIRCStateImpl().getChannelsMutable().remove(aChan);
        this.getPreviousIRCStateImpl().getChannelsMutable().add(StateUtils.cloneChannel(aChan));
    }
}

