/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IRCException;
import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCTopic;
import com.ircclouds.irc.api.domain.IRCUser;
import com.ircclouds.irc.api.domain.IRCUserStatus;
import com.ircclouds.irc.api.domain.IRCUserStatuses;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractChannelJoinListener {
    private Map<String, Callback<IRCChannel>> callbacks = new HashMap<String, Callback<IRCChannel>>();
    private IRCChannel channel;
    private IRCTopic topic;

    public void submit(String aChannelName, Callback<IRCChannel> aCallback) {
        this.callbacks.put(aChannelName, aCallback);
    }

    public void onChanJoinMessage(ChanJoinMessage aMsg) {
        this.channel = new IRCChannel(aMsg.getChannelName());
    }

    public void onServerMessage(ServerNumericMessage aServerMessage) {
        int _numcode = aServerMessage.getNumericCode();
        if (_numcode == 470 || _numcode == 333 || _numcode == 353 || _numcode == 332 || _numcode == 366 || _numcode == 473 || _numcode == 475) {
            if (_numcode == 470) {
                String _newName = aServerMessage.getText().split(" ")[1];
                if (this.channel != null) {
                    this.channel.setName(_newName);
                }
            } else if (_numcode == 353) {
                String[] _nicks;
                for (String _nick : _nicks = aServerMessage.getText().substring(aServerMessage.getText().indexOf(":") + 1).split(" ")) {
                    this.add(_nick);
                }
            } else if (_numcode == 332) {
                this.topic = new IRCTopic(this.getTopic(aServerMessage));
            } else if (_numcode == 333) {
                String[] _cmpnts = aServerMessage.getText().split(" ");
                this.topic.setSetBy(_cmpnts[1]);
                this.topic.setDate(new Date(Long.parseLong(_cmpnts[2] + "000")));
                this.channel.setTopic(this.topic);
            } else if (_numcode == 366) {
                Callback<IRCChannel> _chanCallback;
                if (this.channel.getTopic() == null) {
                    this.channel.setTopic(new IRCTopic(""));
                }
                if ((_chanCallback = this.callbacks.remove(this.channel.getName())) != null) {
                    _chanCallback.onSuccess(this.channel);
                } else {
                    this.saveChannel(this.channel);
                }
            } else if (this.callbacks.containsKey(this.getChannelNameFrom(aServerMessage.getText()))) {
                if (_numcode == 473) {
                    this.callbacks.remove(this.getChannelNameFrom(aServerMessage.getText())).onFailure(new IRCException(aServerMessage.getText()));
                } else if (_numcode == 475) {
                    this.callbacks.remove(this.getChannelNameFrom(aServerMessage.getText())).onFailure(new IRCException(aServerMessage.getText()));
                } else if (_numcode == 474) {
                    this.callbacks.remove(this.getChannelNameFrom(aServerMessage.getText())).onFailure(new IRCException(aServerMessage.getText()));
                }
            }
        }
    }

    protected abstract void saveChannel(IRCChannel var1);

    protected abstract IRCUserStatuses getIRCUserStatuses();

    private String getChannelNameFrom(String aMessage) {
        return aMessage.split(" ")[0];
    }

    private void add(String aNick) {
        boolean _flag = true;
        char _pref = aNick.charAt(0);
        for (final IRCUserStatus _ucs : this.getIRCUserStatuses()) {
            if (!_ucs.getPrefix().equals(Character.valueOf(_pref))) continue;
            this.channel.addUser(new IRCUser(aNick.substring(1)), (Set<IRCUserStatus>)new HashSet<IRCUserStatus>(){
                {
                    this.add(_ucs);
                }
            });
            _flag = false;
            break;
        }
        if (_flag) {
            IRCUser _user = new IRCUser();
            _user.setNick(aNick);
            this.channel.addUser(_user, new HashSet<IRCUserStatus>());
        }
    }

    private String getTopic(ServerNumericMessage aServMsg) {
        return aServMsg.getText().substring(aServMsg.getText().indexOf(":") + 1);
    }
}

