/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.wagon;

import io.tesla.aether.wagon.OkHttpWagon;
import javax.inject.Named;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.component.annotations.Component;

@Named(value="https")
@Component(role=Wagon.class, hint="https")
public class OkHttpsWagon
extends OkHttpWagon {
    private String previousHttpsProxyHost;
    private String previousHttpsProxyPort;
    private String previousHttpsProxyExclusions;

    public void openConnection() throws ConnectionException, AuthenticationException {
        this.previousHttpsProxyHost = System.getProperty("https.proxyHost");
        this.previousHttpsProxyPort = System.getProperty("https.proxyPort");
        this.previousHttpsProxyExclusions = System.getProperty("https.nonProxyHosts");
        ProxyInfo proxyInfo = this.getProxyInfo("https", this.getRepository().getHost());
        if (proxyInfo != null) {
            this.setSystemProperty("https.proxyHost", proxyInfo.getHost());
            this.setSystemProperty("https.proxyPort", String.valueOf(proxyInfo.getPort()));
            this.setSystemProperty("https.nonProxyHosts", proxyInfo.getNonProxyHosts());
        } else {
            this.setSystemProperty("https.proxyHost", null);
            this.setSystemProperty("https.proxyPort", null);
        }
        super.openConnection();
    }

    @Override
    public void closeConnection() throws ConnectionException {
        super.closeConnection();
        this.setSystemProperty("https.proxyHost", this.previousHttpsProxyHost);
        this.setSystemProperty("https.proxyPort", this.previousHttpsProxyPort);
        this.setSystemProperty("https.nonProxyHosts", this.previousHttpsProxyExclusions);
    }
}

