/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4JNI;
import net.jpountz.util.Utils;

final class LZ4JNIDecompressor
extends LZ4Decompressor {
    public static final LZ4JNIDecompressor INSTANCE = new LZ4JNIDecompressor();

    LZ4JNIDecompressor() {
    }

    @Override
    public final int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        Utils.checkRange(src, srcOff);
        Utils.checkRange(dest, destOff, destLen);
        int result = LZ4JNI.LZ4_decompress(src, srcOff, dest, destOff, destLen);
        if (result < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result) + " of input buffer");
        }
        return result;
    }
}

