/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.smile;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import java.io.IOException;
import java.io.InputStream;

public class SmileParserBootstrapper {
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public SmileParserBootstrapper(IOContext iOContext, InputStream inputStream) {
        this._context = iOContext;
        this._in = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public SmileParserBootstrapper(IOContext iOContext, byte[] byArray, int n, int n2) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n + n2;
        this._inputProcessed = -n;
        this._bufferRecyclable = false;
    }

    public SmileParser constructParser(int n, int n2, boolean bl, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer) throws IOException, JsonParseException {
        BytesToNameCanonicalizer bytesToNameCanonicalizer2 = bytesToNameCanonicalizer.makeChild(true, bl);
        this.ensureLoaded(1);
        SmileParser smileParser = new SmileParser(this._context, n, n2, objectCodec, bytesToNameCanonicalizer2, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        boolean bl2 = false;
        if (this._inputPtr < this._inputEnd) {
            if (this._inputBuffer[this._inputPtr] == 58) {
                bl2 = smileParser.handleSignature(true, true);
            }
        } else {
            return smileParser;
        }
        if (!bl2 && (n2 & SmileParser.Feature.REQUIRE_HEADER.getMask()) != 0) {
            byte by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr] : (byte)0;
            String string = by == 123 || by == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by & 0xFF) + ") -- rather, it starts with '" + (char)by + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
            throw new JsonParseException(string, JsonLocation.NA);
        }
        return smileParser;
    }

    public static MatchStrength hasSmileFormat(InputAccessor inputAccessor) throws IOException {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by2 = inputAccessor.nextByte();
        if (by == 58) {
            if (by2 != 41) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            return inputAccessor.nextByte() == 10 ? MatchStrength.FULL_MATCH : MatchStrength.NO_MATCH;
        }
        if (by == -6) {
            if (by2 == 52) {
                return MatchStrength.SOLID_MATCH;
            }
            int n = by2 & 0xFF;
            if (n >= 128 && n < 248) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (by == -8) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (SmileParserBootstrapper.likelySmileValue(by2) || SmileParserBootstrapper.possibleSmileValue(by2, true)) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (SmileParserBootstrapper.likelySmileValue(by) || SmileParserBootstrapper.possibleSmileValue(by2, false)) {
            return MatchStrength.SOLID_MATCH;
        }
        return MatchStrength.NO_MATCH;
    }

    private static boolean likelySmileValue(byte by) {
        if (by == -32 || by == -28 || by == -24 || by == -8 || by == -6) {
            return true;
        }
        int n = by & 0xFF;
        return n >= 128 && n <= 159;
    }

    private static boolean possibleSmileValue(byte by, boolean bl) {
        int n = by & 0xFF;
        if (n >= 128) {
            return n <= 224;
        }
        if (bl) {
            if (n >= 64) {
                return true;
            }
            if (n > -32) {
                return n < 44;
            }
        }
        return false;
    }

    protected boolean ensureLoaded(int n) throws IOException {
        int n2;
        if (this._in == null) {
            return false;
        }
        for (int i = this._inputEnd - this._inputPtr; i < n; i += n2) {
            n2 = this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n2 < 1) {
                return false;
            }
            this._inputEnd += n2;
        }
        return true;
    }
}

