/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class PolyBind {
    public static <T> ScopedBindingBuilder createChoice(Binder binder, String property, Key<T> interfaceKey, @Nullable Key<? extends T> defaultKey) {
        return binder.bind(interfaceKey).toProvider(new ConfiggedProvider<T>(interfaceKey, property, defaultKey));
    }

    public static <T> MapBinder<String, T> optionBinder(Binder binder, Key<T> interfaceKey) {
        TypeLiteral interfaceType = interfaceKey.getTypeLiteral();
        if (interfaceKey.getAnnotation() != null) {
            return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)interfaceType, (Annotation)interfaceKey.getAnnotation());
        }
        if (interfaceKey.getAnnotationType() != null) {
            return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)interfaceType, (Class)interfaceKey.getAnnotationType());
        }
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)interfaceType);
    }

    static class ConfiggedProvider<T>
    implements Provider<T> {
        private final Key<T> key;
        private final String property;
        private final Key<? extends T> defaultKey;
        private Injector injector;
        private Properties props;

        ConfiggedProvider(Key<T> key, String property, Key<? extends T> defaultKey) {
            this.key = key;
            this.property = property;
            this.defaultKey = defaultKey;
        }

        @Inject
        void configure(Injector injector, Properties props) {
            this.injector = injector;
            this.props = props;
        }

        public T get() {
            String implName;
            ParameterizedType mapType = Types.mapOf(String.class, (Type)Types.newParameterizedType(Provider.class, (Type[])new Type[]{this.key.getTypeLiteral().getType()}));
            Map implsMap = this.key.getAnnotation() != null ? (Map)this.injector.getInstance(Key.get((Type)mapType, (Annotation)this.key.getAnnotation())) : (this.key.getAnnotationType() != null ? (Map)this.injector.getInstance(Key.get((Type)mapType, (Annotation)this.key.getAnnotation())) : (Map)this.injector.getInstance(Key.get((Type)mapType)));
            Provider provider = (Provider)implsMap.get(implName = this.props.getProperty(this.property));
            if (provider == null) {
                if (this.defaultKey == null) {
                    throw new ProvisionException(String.format("Unknown provider[%s] of %s, known options[%s]", implName, this.key, implsMap.keySet()));
                }
                return (T)this.injector.getInstance(this.defaultKey);
            }
            return (T)provider.get();
        }
    }
}

