/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.metamx.common.parsers.ParserUtils;
import java.util.Map;
import org.joda.time.DateTime;

public class TimestampSpec {
    private static final String defaultFormat = "auto";
    private final String timestampColumn;
    private final String timestampFormat;
    private final Function<String, DateTime> timestampConverter;

    @JsonCreator
    public TimestampSpec(@JsonProperty(value="column") String timestampColumn, @JsonProperty(value="format") String format) {
        this.timestampColumn = timestampColumn == null ? null : timestampColumn.toLowerCase();
        this.timestampFormat = format == null ? defaultFormat : format.toLowerCase();
        this.timestampConverter = ParserUtils.createTimestampParser((String)this.timestampFormat);
    }

    @JsonProperty(value="column")
    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    @JsonProperty(value="format")
    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public DateTime extractTimestamp(Map<String, Object> input) {
        Object o = input.get(this.timestampColumn);
        return o == null ? null : (DateTime)this.timestampConverter.apply((Object)o.toString());
    }
}

