/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.metamx.common.exception.FormattedException;
import com.metamx.common.parsers.Parser;
import com.metamx.common.parsers.ToLowerCaseParser;
import io.druid.data.input.ByteBufferInputRowParser;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Map;

public class StringInputRowParser
implements ByteBufferInputRowParser {
    private final MapInputRowParser inputRowCreator;
    private final Parser<String, Object> parser;
    private final DataSpec dataSpec;
    private CharBuffer chars = null;

    @JsonCreator
    public StringInputRowParser(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="data") DataSpec dataSpec, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions) {
        this.dataSpec = dataSpec;
        this.inputRowCreator = new MapInputRowParser(timestampSpec, dataSpec.getDimensions(), dimensionExclusions);
        this.parser = new ToLowerCaseParser(dataSpec.getParser());
    }

    @Override
    public void addDimensionExclusion(String dimension) {
        this.inputRowCreator.addDimensionExclusion(dimension);
    }

    @Override
    public InputRow parse(ByteBuffer input) throws FormattedException {
        return this.parseMap(this.buildStringKeyMap(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> buildStringKeyMap(ByteBuffer input) {
        Map<String, Object> theMap;
        CoderResult coderResult;
        int payloadSize = input.remaining();
        if (this.chars == null || this.chars.remaining() < payloadSize) {
            this.chars = CharBuffer.allocate(payloadSize);
        }
        if ((coderResult = Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(input, this.chars, true)).isUnderflow()) {
            this.chars.flip();
            try {
                theMap = this.parseString(this.chars.toString());
            }
            finally {
                this.chars.clear();
            }
        } else {
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_ROW).withMessage(String.format("Failed with CoderResult[%s]", coderResult)).build();
        }
        return theMap;
    }

    private Map<String, Object> parseString(String inputString) {
        return this.parser.parse(inputString);
    }

    @Override
    public InputRow parse(String input) throws FormattedException {
        return this.parseMap(this.parseString(input));
    }

    private InputRow parseMap(Map<String, Object> theMap) {
        return this.inputRowCreator.parse(theMap);
    }

    @JsonProperty
    public TimestampSpec getTimestampSpec() {
        return this.inputRowCreator.getTimestampSpec();
    }

    @JsonProperty(value="data")
    public DataSpec getDataSpec() {
        return this.dataSpec;
    }

    @JsonProperty
    public List<String> getDimensionExclusions() {
        return ImmutableList.copyOf(this.inputRowCreator.getDimensionExclusions());
    }
}

