/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.exception.FormattedException;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public class MapInputRowParser
implements InputRowParser<Map<String, Object>> {
    private final TimestampSpec timestampSpec;
    private List<String> dimensions;
    private final Set<String> dimensionExclusions;

    @JsonCreator
    public MapInputRowParser(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions) {
        this.timestampSpec = timestampSpec;
        if (dimensions != null) {
            this.dimensions = ImmutableList.copyOf(dimensions);
        }
        this.dimensionExclusions = Sets.newHashSet();
        if (dimensionExclusions != null) {
            for (String dimensionExclusion : dimensionExclusions) {
                this.dimensionExclusions.add(dimensionExclusion.toLowerCase());
            }
        }
        this.dimensionExclusions.add(timestampSpec.getTimestampColumn().toLowerCase());
    }

    @Override
    public InputRow parse(Map<String, Object> theMap) throws FormattedException {
        DateTime timestamp;
        ArrayList dimensions = this.hasCustomDimensions() ? this.dimensions : Lists.newArrayList((Iterable)Sets.difference(theMap.keySet(), this.dimensionExclusions));
        try {
            timestamp = this.timestampSpec.extractTimestamp(theMap);
            if (timestamp == null) {
                String input = theMap.toString();
                throw new NullPointerException(String.format("Null timestamp in input: %s", input.length() < 100 ? input : input.substring(0, 100) + "..."));
            }
        }
        catch (Exception e) {
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_TIMESTAMP).withMessage(e.toString()).build();
        }
        return new MapBasedInputRow(timestamp.getMillis(), dimensions, theMap);
    }

    private boolean hasCustomDimensions() {
        return this.dimensions != null;
    }

    @Override
    public void addDimensionExclusion(String dimension) {
        this.dimensionExclusions.add(dimension);
    }

    @JsonProperty
    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public Set<String> getDimensionExclusions() {
        return this.dimensionExclusions;
    }
}

