/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.parsers.CSVParser;
import com.metamx.common.parsers.Parser;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.SpatialDimensionSchema;
import java.util.List;

public class CSVDataSpec
implements DataSpec {
    private final List<String> columns;
    private final List<String> dimensions;
    private final List<SpatialDimensionSchema> spatialDimensions;

    @JsonCreator
    public CSVDataSpec(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions) {
        Preconditions.checkNotNull(columns, (Object)"columns");
        for (String column : columns) {
            Preconditions.checkArgument((!column.contains(",") ? 1 : 0) != 0, (String)"Column[%s] has a comma, it cannot", (Object[])new Object[]{column});
        }
        this.columns = columns;
        this.dimensions = dimensions;
        this.spatialDimensions = spatialDimensions == null ? Lists.newArrayList() : spatialDimensions;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    @JsonProperty(value="dimensions")
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Override
    @JsonProperty(value="spatialDimensions")
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }

    @Override
    public void verify(List<String> usedCols) {
        for (String columnName : usedCols) {
            Preconditions.checkArgument((boolean)this.columns.contains(columnName), (String)"column[%s] not in columns.", (Object[])new Object[]{columnName});
        }
    }

    @Override
    public boolean hasCustomDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    @Override
    public Parser<String, Object> getParser() {
        return new CSVParser(this.columns);
    }
}

