/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.common.IAE;
import com.metamx.common.exception.FormattedException;
import io.druid.data.input.Row;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class MapBasedRow
implements Row {
    private final DateTime timestamp;
    private final Map<String, Object> event;

    @JsonCreator
    public MapBasedRow(@JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="event") Map<String, Object> event) {
        this.timestamp = timestamp;
        this.event = event;
    }

    public MapBasedRow(long timestamp, Map<String, Object> event) {
        this(new DateTime(timestamp), event);
    }

    @Override
    public long getTimestampFromEpoch() {
        return this.timestamp.getMillis();
    }

    @Override
    public List<String> getDimension(String dimension) {
        Object dimValue = this.event.get(dimension);
        if (dimValue == null) {
            return Lists.newArrayList();
        }
        if (dimValue instanceof List) {
            return Lists.transform((List)((List)dimValue), (Function)new Function<Object, String>(){

                public String apply(@Nullable Object input) {
                    return String.valueOf(input);
                }
            });
        }
        if (dimValue instanceof Object) {
            return Arrays.asList(String.valueOf(this.event.get(dimension)));
        }
        throw new IAE("Unknown dim type[%s]", new Object[]{dimValue.getClass()});
    }

    @Override
    public Object getRaw(String dimension) {
        return this.event.get(dimension);
    }

    @Override
    public float getFloatMetric(String metric) {
        Object metricValue = this.event.get(metric);
        if (metricValue == null) {
            return 0.0f;
        }
        if (metricValue instanceof Number) {
            return ((Number)metricValue).floatValue();
        }
        if (metricValue instanceof String) {
            try {
                return Float.valueOf(((String)metricValue).replace(",", "")).floatValue();
            }
            catch (Exception e) {
                throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_METRIC).withDetails((Map)ImmutableMap.of((Object)"metricName", (Object)metric, (Object)"metricValue", (Object)metricValue)).withMessage(e.getMessage()).build();
            }
        }
        throw new IAE("Unknown type[%s]", new Object[]{metricValue.getClass()});
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Map<String, Object> getEvent() {
        return this.event;
    }

    public String toString() {
        return "MapBasedRow{timestamp=" + this.timestamp + ", event=" + this.event + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBasedRow that = (MapBasedRow)o;
        if (!this.event.equals(that.event)) {
            return false;
        }
        return this.timestamp.equals((Object)that.timestamp);
    }

    public int hashCode() {
        int result = this.timestamp.hashCode();
        result = 31 * result + this.event.hashCode();
        return result;
    }
}

