/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalDateSerializer
extends JodaSerializerBase<LocalDate> {
    static final DateTimeFormatter format = ISODateTimeFormat.date();

    public LocalDateSerializer() {
        super(LocalDate.class);
    }

    public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeNumber(localDate.year().get());
            jsonGenerator.writeNumber(localDate.monthOfYear().get());
            jsonGenerator.writeNumber(localDate.dayOfMonth().get());
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(format.print((ReadablePartial)localDate));
        }
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode(serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) ? "array" : "string", true);
    }
}

