/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.Instant;

public final class InstantSerializer
extends JodaSerializerBase<Instant> {
    public InstantSerializer() {
        super(Instant.class);
    }

    public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(instant.getMillis());
        } else {
            jsonGenerator.writeString(instant.toString());
        }
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode(serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) ? "number" : "string", true);
    }
}

