/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import java.io.IOException;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class LocalTimeDeserializer
extends JodaDeserializerBase<LocalTime> {
    static final DateTimeFormatter parser = ISODateTimeFormat.localTimeParser();

    public LocalTimeDeserializer() {
        super(LocalTime.class);
    }

    public LocalTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        switch (jsonParser.getCurrentToken()) {
            case START_ARRAY: {
                if (!jsonParser.isExpectedStartArrayToken()) break;
                jsonParser.nextToken();
                int n = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n2 = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n3 = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n4 = 0;
                if (jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                    n4 = jsonParser.getIntValue();
                    jsonParser.nextToken();
                }
                if (jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                    throw deserializationContext.wrongTokenException(jsonParser, JsonToken.END_ARRAY, "after LocalTime ints");
                }
                return new LocalTime(n, n2, n3, n4);
            }
            case VALUE_NUMBER_INT: {
                return new LocalTime(jsonParser.getLongValue());
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return parser.parseLocalTime(string);
            }
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.START_ARRAY, "expected JSON Array, String or Number");
    }
}

