/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import java.io.IOException;
import org.joda.time.DateMidnight;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateMidnightDeserializer
extends JodaDeserializerBase<DateMidnight> {
    static final DateTimeFormatter parser = ISODateTimeFormat.localDateParser();

    public DateMidnightDeserializer() {
        super(DateMidnight.class);
    }

    public DateMidnight deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.isExpectedStartArrayToken()) {
            jsonParser.nextToken();
            int n = jsonParser.getIntValue();
            jsonParser.nextToken();
            int n2 = jsonParser.getIntValue();
            jsonParser.nextToken();
            int n3 = jsonParser.getIntValue();
            if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                throw deserializationContext.wrongTokenException(jsonParser, JsonToken.END_ARRAY, "after DateMidnight ints");
            }
            return new DateMidnight(n, n2, n3);
        }
        switch (jsonParser.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                return new DateMidnight(jsonParser.getLongValue());
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                LocalDate localDate = parser.parseLocalDate(string);
                if (localDate == null) {
                    return null;
                }
                return localDate.toDateMidnight();
            }
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.START_ARRAY, "expected JSON Array, Number or String");
    }
}

