/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.internal.guava.base.;
import com.google.inject.servlet.DefaultFilterPipeline;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.ManagedFilterPipeline;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GuiceFilter
implements Filter {
    static final ThreadLocal<Context> localContext = new ThreadLocal();
    static volatile FilterPipeline pipeline = new DefaultFilterPipeline();
    private final FilterPipeline injectedPipeline;
    static volatile WeakReference<ServletContext> servletContext = new WeakReference<Object>(null);
    private static final String MULTIPLE_INJECTORS_WARNING = "Multiple Servlet injectors detected. This is a warning indicating that you have more than one " + GuiceFilter.class.getSimpleName() + " running " + "in your web application. If this is deliberate, you may safely " + "ignore this message. If this is NOT deliberate however, " + "your application may not work as expected.";
    private static final Logger LOGGER = Logger.getLogger(GuiceFilter.class.getName());

    public GuiceFilter() {
        this(null);
    }

    @Inject
    GuiceFilter(FilterPipeline filterPipeline) {
        this.injectedPipeline = filterPipeline;
    }

    @Inject
    static void setPipeline(FilterPipeline pipeline) {
        if (GuiceFilter.pipeline instanceof ManagedFilterPipeline) {
            LOGGER.warning(MULTIPLE_INJECTORS_WARNING);
        }
        GuiceFilter.pipeline = pipeline;
    }

    static void reset() {
        pipeline = new DefaultFilterPipeline();
        localContext.remove();
    }

    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain) throws IOException, ServletException {
        final FilterPipeline filterPipeline = this.getFilterPipeline();
        Context previous = localContext.get();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest originalRequest = previous != null ? previous.getOriginalRequest() : request;
        try {
            new Context(originalRequest, request, response).call(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    filterPipeline.dispatch(servletRequest, servletResponse, filterChain);
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            .Throwables.propagate((Throwable)e);
        }
    }

    static HttpServletRequest getOriginalRequest() {
        return GuiceFilter.getContext().getOriginalRequest();
    }

    static HttpServletRequest getRequest() {
        return GuiceFilter.getContext().getRequest();
    }

    static HttpServletResponse getResponse() {
        return GuiceFilter.getContext().getResponse();
    }

    static ServletContext getServletContext() {
        return (ServletContext)servletContext.get();
    }

    private static Context getContext() {
        Context context = localContext.get();
        if (context == null) {
            throw new OutOfScopeException("Cannot access scoped object. Either we are not currently inside an HTTP Servlet request, or you may have forgotten to apply " + GuiceFilter.class.getName() + " as a servlet filter for this request.");
        }
        return context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        GuiceFilter.servletContext = new WeakReference<ServletContext>(servletContext);
        FilterPipeline filterPipeline = this.getFilterPipeline();
        filterPipeline.initPipeline(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            FilterPipeline filterPipeline = this.getFilterPipeline();
            filterPipeline.destroyPipeline();
        }
        finally {
            GuiceFilter.reset();
            servletContext.clear();
        }
    }

    private FilterPipeline getFilterPipeline() {
        return null != this.injectedPipeline ? this.injectedPipeline : pipeline;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Context {
        final HttpServletRequest originalRequest;
        final HttpServletRequest request;
        final HttpServletResponse response;
        volatile Thread owner;

        Context(HttpServletRequest originalRequest, HttpServletRequest request, HttpServletResponse response) {
            this.originalRequest = originalRequest;
            this.request = request;
            this.response = response;
        }

        HttpServletRequest getOriginalRequest() {
            return this.originalRequest;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        HttpServletResponse getResponse() {
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T call(Callable<T> callable) throws Exception {
            Thread oldOwner = this.owner;
            Thread newOwner = Thread.currentThread();
            .Preconditions.checkState((oldOwner == null || oldOwner == newOwner ? 1 : 0) != 0, (Object)"Trying to transfer request scope but original scope is still active");
            this.owner = newOwner;
            Context previous = localContext.get();
            localContext.set(this);
            try {
                T t = callable.call();
                return t;
            }
            finally {
                this.owner = oldOwner;
                localContext.set(previous);
            }
        }
    }
}

