/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import java.io.Serializable;

public class Message
implements Serializable {
    private Content subject;
    private Body body;

    public Message() {
    }

    public Message(Content subject, Body body) {
        this.setSubject(subject);
        this.setBody(body);
    }

    public Content getSubject() {
        return this.subject;
    }

    public void setSubject(Content subject) {
        this.subject = subject;
    }

    public Message withSubject(Content subject) {
        this.subject = subject;
        return this;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Message withBody(Body body) {
        this.body = body;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubject() != null) {
            sb.append("Subject: " + this.getSubject() + ",");
        }
        if (this.getBody() != null) {
            sb.append("Body: " + this.getBody());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        return other.getBody() == null || other.getBody().equals(this.getBody());
    }
}

