/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3OriginConfigStaxUnmarshaller
implements Unmarshaller<S3OriginConfig, StaxUnmarshallerContext> {
    private static S3OriginConfigStaxUnmarshaller instance;

    @Override
    public S3OriginConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3OriginConfig s3OriginConfig = new S3OriginConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3OriginConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("OriginAccessIdentity", targetDepth)) continue;
                s3OriginConfig.setOriginAccessIdentity(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3OriginConfig;
    }

    public static S3OriginConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3OriginConfigStaxUnmarshaller();
        }
        return instance;
    }
}

