/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.utilities;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap<T>
extends AbstractMap<Integer, T>
implements Serializable {
    private static final long serialVersionUID = -578029467093308343L;
    private final T[] array;
    private transient Set<Map.Entry<Integer, T>> entrySet;
    private final int indexShift;

    ArrayMap(T[] array, int indexShift) {
        this.array = array;
        this.indexShift = indexShift;
        this.entrySet = null;
    }

    ArrayMap(T[] array) {
        this(array, 0);
    }

    @Override
    public Set<Map.Entry<Integer, T>> entrySet() {
        if (this.entrySet == null) {
            final ArrayList<SimpleEntry> entries = new ArrayList<SimpleEntry>(this.array.length);
            for (int i = 0; i < this.array.length; ++i) {
                entries.add(new SimpleEntry(i));
            }
            this.entrySet = new AbstractSet<Map.Entry<Integer, T>>(){

                @Override
                public Iterator<Map.Entry<Integer, T>> iterator() {
                    return new Iterator<Map.Entry<Integer, T>>(){
                        int curr = 0;

                        @Override
                        public boolean hasNext() {
                            return this.curr < entries.size();
                        }

                        @Override
                        public Map.Entry<Integer, T> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            return (Map.Entry)entries.get(this.curr++);
                        }

                        @Override
                        public void remove() {
                            throw new IllegalArgumentException();
                        }
                    };
                }

                @Override
                public int size() {
                    return entries.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = (Integer)key - this.indexShift;
        return index >= 0 && index < this.array.length;
    }

    @Override
    public T get(Object key) {
        return this.array[(Integer)key - this.indexShift];
    }

    @Override
    public T put(Integer key, T value) {
        int actualIndex = key - this.indexShift;
        T old = this.array[actualIndex];
        this.array[actualIndex] = value;
        return old;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ArrayMap)) {
            return false;
        }
        return Arrays.equals(this.array, ((ArrayMap)obj).array);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.entrySet = null;
    }

    public static void main(String[] args) {
        ArrayMap<String> am = new ArrayMap<String>(new String[]{"Three", "Four", "Five"}, 3);
        System.out.println(am);
        am.put(5, "FIVE");
        System.out.println(am);
        System.out.println(am.get(5));
        System.out.println(am.containsKey(2));
        System.out.println(am.containsKey(3));
        System.out.println(am.containsValue("THREE"));
        System.out.println(am.keySet());
        System.out.println(am.values());
    }

    private class SimpleEntry
    implements Map.Entry<Integer, T> {
        final int actualIndex;

        private SimpleEntry(int index) {
            this.actualIndex = index;
        }

        @Override
        public Integer getKey() {
            return this.actualIndex + ArrayMap.this.indexShift;
        }

        @Override
        public T getValue() {
            return ArrayMap.this.array[this.actualIndex];
        }

        @Override
        public T setValue(T value) {
            Object old = ArrayMap.this.array[this.actualIndex];
            ((ArrayMap)ArrayMap.this).array[this.actualIndex] = value;
            return old;
        }

        public String toString() {
            return this.actualIndex + ArrayMap.this.indexShift + "=" + ArrayMap.this.array[this.actualIndex];
        }
    }
}

