/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.intset;

import it.uniroma3.mat.extendedset.intset.AbstractIntSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import it.uniroma3.mat.extendedset.utilities.IntHashCode;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class HashIntSet
extends AbstractIntSet {
    protected static final int INITIAL_SIZE = 3;
    protected static final double LOAD_FACTOR = 0.75;
    protected static final int EMPTY = -1;
    protected static final int REMOVED = -2;
    protected int size;
    protected int freecells;
    protected int[] cells;
    protected int modCount;

    public HashIntSet() {
        this(3);
    }

    public HashIntSet(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.cells = new int[initialSize];
        this.modCount = 0;
        this.clear();
    }

    @Override
    public IntSet.IntIterator iterator() {
        return new SortedIterator();
    }

    @Override
    public IntSet.IntIterator descendingIterator() {
        return new DescendingSortedIterator();
    }

    public IntSet.IntIterator unsortedIterator() {
        return new UnsortedIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private final int toIndex(int o) {
        return (o & Integer.MAX_VALUE) % this.cells.length;
    }

    private int findElementOrEmpty(int element) {
        assert (element >= 0);
        int index = this.toIndex(IntHashCode.hashCode(element));
        int offset = 1;
        while (this.cells[index] != -1) {
            if (this.cells[index] == element) {
                return index;
            }
            index = this.toIndex(index + offset);
            offset <<= 1;
            if (++offset >= 0) continue;
            offset = 2;
        }
        return -(index + 1);
    }

    private int findElementOrRemoved(int element) {
        assert (element >= 0);
        int index = this.toIndex(IntHashCode.hashCode(element));
        int offset = 1;
        int removed = -1;
        while (this.cells[index] != -1) {
            if (this.cells[index] == element) {
                return index;
            }
            if (this.cells[index] == -2) {
                removed = index;
            }
            index = this.toIndex(index + offset);
            offset <<= 1;
            if (++offset >= 0) continue;
            offset = 2;
        }
        if (removed >= 0) {
            return -(removed + 1);
        }
        return index;
    }

    @Override
    public boolean contains(int element) {
        if (element < 0) {
            throw new IndexOutOfBoundsException("element < 0: " + element);
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.findElementOrEmpty(element) >= 0;
    }

    @Override
    public boolean add(int element) {
        if (element < 0) {
            throw new IndexOutOfBoundsException("element < 0: " + element);
        }
        int index = this.findElementOrRemoved(element);
        if (index >= 0) {
            if (this.cells[index] == element) {
                return false;
            }
            --this.freecells;
        } else {
            index = -(index + 1);
        }
        ++this.modCount;
        ++this.size;
        this.cells[index] = element;
        if (1.0 - (double)this.freecells / (double)this.cells.length > 0.75) {
            this.rehash();
        }
        return true;
    }

    @Override
    public boolean remove(int element) {
        if (element < 0) {
            throw new IndexOutOfBoundsException("element < 0: " + element);
        }
        int index = this.findElementOrEmpty(element);
        if (index < 0) {
            return false;
        }
        this.cells[index] = -2;
        ++this.modCount;
        --this.size;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.cells, -1);
        this.freecells = this.cells.length;
        ++this.modCount;
    }

    protected void rehash() {
        int gargagecells = this.cells.length - (this.size + this.freecells);
        if ((double)gargagecells / (double)this.cells.length > 0.05) {
            this.rehash(this.cells.length);
        } else {
            this.rehash((this.cells.length << 1) + 1);
        }
    }

    protected void rehash(int newCapacity) {
        HashIntSet rehashed = new HashIntSet(newCapacity);
        int[] cells = rehashed.cells;
        for (int element : this.cells) {
            if (element < 0) continue;
            cells[-(rehashed.findElementOrEmpty((int)element) + 1)] = element;
        }
        this.cells = cells;
        this.freecells = newCapacity - this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(IntSet c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        IntSet.IntIterator itr = c instanceof HashIntSet ? ((HashIntSet)c).unsortedIterator() : c.iterator();
        boolean res = false;
        while (itr.hasNext()) {
            res |= this.add(itr.next());
        }
        return res;
    }

    @Override
    public boolean removeAll(IntSet c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        IntSet.IntIterator itr = c instanceof HashIntSet ? ((HashIntSet)c).unsortedIterator() : c.iterator();
        boolean res = false;
        while (itr.hasNext()) {
            res |= this.remove(itr.next());
        }
        return res;
    }

    @Override
    public boolean retainAll(IntSet c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        boolean res = false;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] < 0 || c.contains(this.cells[i])) continue;
            this.cells[i] = -2;
            res = true;
            --this.size;
        }
        if (res) {
            ++this.modCount;
        }
        return res;
    }

    @Override
    public HashIntSet clone() {
        HashIntSet cloned = new HashIntSet(this.cells.length);
        System.arraycopy(this.cells, 0, cloned.cells, 0, this.cells.length);
        cloned.freecells = this.freecells;
        cloned.size = this.size;
        cloned.modCount = 0;
        return cloned;
    }

    @Override
    public double bitmapCompressionRatio() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return (double)this.cells.length / Math.ceil((double)this.last() / 32.0);
    }

    @Override
    public double collectionCompressionRatio() {
        return this.isEmpty() ? 0.0 : (double)this.cells.length / (double)this.size();
    }

    @Override
    public HashIntSet complemented() {
        return (HashIntSet)super.complemented();
    }

    @Override
    public boolean containsAll(IntSet c) {
        boolean res;
        IntSet.IntIterator itr = c instanceof HashIntSet ? ((HashIntSet)c).unsortedIterator() : c.iterator();
        for (res = true; res && itr.hasNext(); res &= this.contains(itr.next())) {
        }
        return res;
    }

    @Override
    public boolean containsAny(IntSet c) {
        IntSet.IntIterator itr = c instanceof HashIntSet ? ((HashIntSet)c).unsortedIterator() : c.iterator();
        boolean res = true;
        while (res && itr.hasNext()) {
            if (!this.contains(itr.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(IntSet c, int minElements) {
        IntSet.IntIterator itr = c instanceof HashIntSet ? ((HashIntSet)c).unsortedIterator() : c.iterator();
        while (minElements > 0 && itr.hasNext()) {
            if (!this.contains(itr.next())) continue;
            --minElements;
        }
        return minElements == 0;
    }

    @Override
    public HashIntSet convert(int ... a) {
        HashIntSet res = new HashIntSet((int)((double)a.length / 0.75) + 1);
        for (int e : a) {
            res.add(e);
        }
        return res;
    }

    @Override
    public HashIntSet convert(Collection<Integer> c) {
        HashIntSet res = new HashIntSet((int)((double)c.size() / 0.75) + 1);
        for (int e : c) {
            res.add(e);
        }
        return res;
    }

    @Override
    public String debugInfo() {
        return "size: " + this.size + ", freecells: " + this.freecells + ", " + Arrays.toString(this.cells);
    }

    @Override
    public HashIntSet symmetricDifference(IntSet c) {
        HashIntSet res = this.clone();
        IntSet.IntIterator itr = c instanceof HashIntSet ? ((HashIntSet)c).unsortedIterator() : c.iterator();
        while (itr.hasNext()) {
            res.flip(itr.next());
        }
        return res;
    }

    @Override
    public HashIntSet union(IntSet other) {
        return (HashIntSet)super.union(other);
    }

    @Override
    public HashIntSet difference(IntSet other) {
        return (HashIntSet)super.difference(other);
    }

    @Override
    public HashIntSet intersection(IntSet other) {
        return (HashIntSet)super.intersection(other);
    }

    @Override
    public HashIntSet empty() {
        return new HashIntSet();
    }

    @Override
    public void flip(int element) {
        if (element < 0) {
            throw new IndexOutOfBoundsException("element < 0: " + element);
        }
        ++this.modCount;
        int index = this.findElementOrRemoved(element);
        if (index >= 0) {
            if (this.cells[index] == element) {
                this.cells[index] = -2;
                --this.size;
                return;
            }
            --this.freecells;
        } else {
            index = -(index + 1);
        }
        this.cells[index] = element;
        ++this.size;
        if (1.0 - (double)this.freecells / (double)this.cells.length > 0.75) {
            this.rehash();
        }
    }

    @Override
    public int get(int i) {
        return this.toArray()[i];
    }

    @Override
    public int indexOf(int e) {
        if (e < 0) {
            throw new IllegalArgumentException("positive integer expected: " + Integer.toString(e));
        }
        return Arrays.binarySearch(this.toArray(), e);
    }

    @Override
    public int intersectionSize(IntSet c) {
        int res = 0;
        IntSet.IntIterator itr = c instanceof HashIntSet ? ((HashIntSet)c).unsortedIterator() : c.iterator();
        while (itr.hasNext()) {
            if (!this.contains(itr.next())) continue;
            ++res;
        }
        return res;
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = 0;
        for (int element : this.cells) {
            if (max >= element) continue;
            max = element;
        }
        return max;
    }

    @Override
    public int first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min = Integer.MAX_VALUE;
        for (int element : this.cells) {
            if (element < 0 || min <= element) continue;
            min = element;
        }
        return min;
    }

    @Override
    public int[] toArray(int[] a) {
        if (a.length < this.size) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return a;
        }
        int i = 0;
        for (int element : this.cells) {
            if (element < 0) continue;
            a[i++] = element;
        }
        Arrays.sort(a, 0, this.size);
        return a;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int h = 1;
        for (int e : this.cells) {
            if (e < 0) continue;
            h ^= IntHashCode.hashCode(e);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HashIntSet)) {
            return super.equals(obj);
        }
        HashIntSet other = (HashIntSet)obj;
        if (this.size != other.size) {
            return false;
        }
        for (int e : other.cells) {
            if (e < 0 || this.contains(e)) continue;
            return false;
        }
        return true;
    }

    private class DescendingSortedIterator
    implements IntSet.IntIterator {
        int[] elements;
        int next;

        private DescendingSortedIterator() {
            this.elements = HashIntSet.this.toArray();
            this.next = HashIntSet.this.size - 1;
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.next--];
        }

        @Override
        public void remove() {
            if (this.elements[this.next + 1] == -2) {
                throw new IllegalStateException();
            }
            HashIntSet.this.remove(this.elements[this.next + 1]);
            this.elements[this.next + 1] = -2;
        }

        @Override
        public void skipAllBefore(int element) {
            if (element >= this.elements[this.next]) {
                return;
            }
            this.next = Arrays.binarySearch(this.elements, 0, this.next, element);
            if (this.next < 0) {
                this.next = -(this.next + 1) - 1;
            }
        }

        @Override
        public IntSet.IntIterator clone() {
            DescendingSortedIterator retVal = new DescendingSortedIterator();
            retVal.elements = (int[])this.elements.clone();
            retVal.next = this.next;
            return retVal;
        }
    }

    private class SortedIterator
    implements IntSet.IntIterator {
        int[] elements;
        int next;

        private SortedIterator() {
            this.elements = HashIntSet.this.toArray();
            this.next = 0;
        }

        @Override
        public boolean hasNext() {
            return this.next < HashIntSet.this.size;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.next++];
        }

        @Override
        public void remove() {
            if (this.elements[this.next - 1] == -2) {
                throw new IllegalStateException();
            }
            HashIntSet.this.remove(this.elements[this.next - 1]);
            this.elements[this.next - 1] = -2;
        }

        @Override
        public void skipAllBefore(int element) {
            if (element <= this.elements[this.next]) {
                return;
            }
            this.next = Arrays.binarySearch(this.elements, this.next + 1, HashIntSet.this.size, element);
            if (this.next < 0) {
                this.next = -(this.next + 1);
            }
        }

        @Override
        public IntSet.IntIterator clone() {
            SortedIterator retVal = new SortedIterator();
            retVal.next = this.next;
            retVal.elements = (int[])this.elements.clone();
            return retVal;
        }
    }

    private class UnsortedIterator
    implements IntSet.IntIterator {
        private int nextIndex = 0;
        private int current = -1;
        private int expectedModCount;

        void skipEmpty() {
            while (this.nextIndex < HashIntSet.this.cells.length && (HashIntSet.this.cells[this.nextIndex] == -1 || HashIntSet.this.cells[this.nextIndex] == -2)) {
                ++this.nextIndex;
            }
        }

        public UnsortedIterator() {
            this.expectedModCount = HashIntSet.this.modCount;
            this.nextIndex = 0;
            this.skipEmpty();
            this.expectedModCount = HashIntSet.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < HashIntSet.this.cells.length;
        }

        @Override
        public int next() {
            if (HashIntSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextIndex >= HashIntSet.this.cells.length) {
                throw new NoSuchElementException();
            }
            this.current = this.nextIndex++;
            this.skipEmpty();
            return HashIntSet.this.cells[this.current];
        }

        @Override
        public void remove() {
            if (HashIntSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.current < 0) {
                throw new IllegalStateException();
            }
            HashIntSet.this.cells[this.current] = -2;
            --HashIntSet.this.size;
            ++HashIntSet.this.modCount;
            this.expectedModCount = HashIntSet.this.modCount;
            this.current = -1;
        }

        @Override
        public void skipAllBefore(int element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntSet.IntIterator clone() {
            UnsortedIterator retVal = new UnsortedIterator();
            retVal.nextIndex = this.nextIndex;
            retVal.current = this.current;
            retVal.expectedModCount = this.expectedModCount;
            return retVal;
        }
    }
}

