/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.intset;

import it.uniroma3.mat.extendedset.intset.AbstractIntSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import it.uniroma3.mat.extendedset.utilities.BitCount;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ConciseSet
extends AbstractIntSet
implements Serializable {
    private static final long serialVersionUID = 560068054685367266L;
    private int[] words;
    private transient int last;
    private transient int size;
    private transient int lastWordIndex;
    private final boolean simulateWAH;
    protected volatile transient int modCount = 0;

    private void reset() {
        ++this.modCount;
        this.words = null;
        this.last = -1;
        this.size = 0;
        this.lastWordIndex = -1;
    }

    public ConciseSet() {
        this(false);
    }

    public ConciseSet(boolean simulateWAH) {
        this.simulateWAH = simulateWAH;
        this.reset();
    }

    public ConciseSet(int[] words, boolean simulateWAH) {
        this.words = words;
        this.lastWordIndex = this.isEmpty() ? -1 : words.length - 1;
        this.size = -1;
        this.updateLast();
        this.simulateWAH = simulateWAH;
    }

    @Override
    public ConciseSet clone() {
        if (this.isEmpty()) {
            return this.empty();
        }
        ConciseSet res = this.empty();
        res.last = this.last;
        res.lastWordIndex = this.lastWordIndex;
        res.modCount = 0;
        res.size = this.size;
        res.words = Arrays.copyOf(this.words, this.lastWordIndex + 1);
        return res;
    }

    private static int maxLiteralLengthModulus(int n) {
        int m = (n & 0xC1F07C1F) + (n >>> 5 & 0xC1F07C1F);
        if ((m = (m >>> 15) + (m & Short.MAX_VALUE)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        if ((m = (m >>> 5) + (m & 0x1F)) <= 31) {
            return m == 31 ? 0 : m;
        }
        return (m = (m >>> 5) + (m & 0x1F)) == 31 ? 0 : m;
    }

    private static int maxLiteralLengthMultiplication(int n) {
        return (n << 5) - n;
    }

    private static int maxLiteralLengthDivision(int n) {
        return n / 31;
    }

    private static boolean isLiteral(int word) {
        return (word & Integer.MIN_VALUE) != 0;
    }

    private static boolean isOneSequence(int word) {
        return (word & 0xC0000000) == 0x40000000;
    }

    private static boolean isZeroSequence(int word) {
        return (word & 0xC0000000) == 0;
    }

    private static boolean isSequenceWithNoBits(int word) {
        return (word & 0xBE000000) == 0;
    }

    private static int getSequenceCount(int word) {
        return word & 0x1FFFFFF;
    }

    private static int getSequenceWithNoBits(int word) {
        return word & 0xC1FFFFFF;
    }

    private int getLiteral(int word) {
        if (ConciseSet.isLiteral(word)) {
            return word;
        }
        if (this.simulateWAH) {
            return ConciseSet.isZeroSequence(word) ? Integer.MIN_VALUE : -1;
        }
        int literal = 1 << (word >>> 25) >>> 1;
        return ConciseSet.isZeroSequence(word) ? Integer.MIN_VALUE | literal : 0xFFFFFFFF & ~literal;
    }

    private static int getFlippedBit(int word) {
        return (word >>> 25 & 0x1F) - 1;
    }

    private static int getLiteralBitCount(int word) {
        return BitCount.count(ConciseSet.getLiteralBits(word));
    }

    private static int getLiteralBits(int word) {
        return Integer.MAX_VALUE & word;
    }

    private void clearBitsAfterInLastWord(int lastSetBit) {
        int n = this.lastWordIndex;
        this.words[n] = this.words[n] & (Integer.MIN_VALUE | -1 >>> 31 - lastSetBit);
    }

    private static boolean containsOnlyOneBit(int literal) {
        return (literal & literal - 1) == 0;
    }

    private void ensureCapacity(int index) {
        int capacity;
        int n = capacity = this.words == null ? 0 : this.words.length;
        if (capacity > index) {
            return;
        }
        capacity = Math.max(capacity << 1, index + 1);
        if (this.words == null) {
            this.words = new int[capacity];
            return;
        }
        this.words = Arrays.copyOf(this.words, capacity);
    }

    private void compact() {
        if (this.words != null && this.lastWordIndex + 1 << 1 < this.words.length) {
            this.words = Arrays.copyOf(this.words, this.lastWordIndex + 1);
        }
    }

    private void append(int i) {
        if (this.isEmpty()) {
            int zeroBlocks = ConciseSet.maxLiteralLengthDivision(i);
            if (zeroBlocks == 0) {
                this.words = new int[1];
                this.lastWordIndex = 0;
            } else if (zeroBlocks == 1) {
                this.words = new int[2];
                this.lastWordIndex = 1;
                this.words[0] = Integer.MIN_VALUE;
            } else {
                this.words = new int[2];
                this.lastWordIndex = 1;
                this.words[0] = zeroBlocks - 1;
            }
            this.last = i;
            this.size = 1;
            this.words[this.lastWordIndex] = Integer.MIN_VALUE | 1 << ConciseSet.maxLiteralLengthModulus(i);
            return;
        }
        int bit = ConciseSet.maxLiteralLengthModulus(this.last) + i - this.last;
        if (bit >= 31) {
            int zeroBlocks = ConciseSet.maxLiteralLengthDivision(bit) - 1;
            bit = ConciseSet.maxLiteralLengthModulus(bit);
            if (zeroBlocks == 0) {
                this.ensureCapacity(this.lastWordIndex + 1);
            } else {
                this.ensureCapacity(this.lastWordIndex + 2);
                this.appendFill(zeroBlocks, 0);
            }
            this.appendLiteral(Integer.MIN_VALUE | 1 << bit);
        } else {
            int n = this.lastWordIndex;
            this.words[n] = this.words[n] | 1 << bit;
            if (this.words[this.lastWordIndex] == -1) {
                --this.lastWordIndex;
                this.appendLiteral(-1);
            }
        }
        this.last = i;
        if (this.size >= 0) {
            ++this.size;
        }
    }

    private void appendLiteral(int word) {
        if (this.lastWordIndex == 0 && word == Integer.MIN_VALUE && this.words[0] == 0x1FFFFFF) {
            return;
        }
        if (this.lastWordIndex < 0) {
            this.lastWordIndex = 0;
            this.words[0] = word;
            return;
        }
        int lastWord = this.words[this.lastWordIndex];
        if (word == Integer.MIN_VALUE) {
            if (lastWord == Integer.MIN_VALUE) {
                this.words[this.lastWordIndex] = 1;
            } else if (ConciseSet.isZeroSequence(lastWord)) {
                int n = this.lastWordIndex;
                this.words[n] = this.words[n] + 1;
            } else if (!this.simulateWAH && ConciseSet.containsOnlyOneBit(ConciseSet.getLiteralBits(lastWord))) {
                this.words[this.lastWordIndex] = 1 | 1 + Integer.numberOfTrailingZeros(lastWord) << 25;
            } else {
                this.words[++this.lastWordIndex] = word;
            }
        } else if (word == -1) {
            if (lastWord == -1) {
                this.words[this.lastWordIndex] = 0x40000001;
            } else if (ConciseSet.isOneSequence(lastWord)) {
                int n = this.lastWordIndex;
                this.words[n] = this.words[n] + 1;
            } else if (!this.simulateWAH && ConciseSet.containsOnlyOneBit(~lastWord)) {
                this.words[this.lastWordIndex] = 0x40000001 | 1 + Integer.numberOfTrailingZeros(~lastWord) << 25;
            } else {
                this.words[++this.lastWordIndex] = word;
            }
        } else {
            this.words[++this.lastWordIndex] = word;
        }
    }

    private void appendFill(int length, int fillType) {
        assert (length > 0);
        assert (this.lastWordIndex >= -1);
        fillType &= 0x40000000;
        if (length == 1) {
            this.appendLiteral(fillType == 0 ? Integer.MIN_VALUE : -1);
            return;
        }
        if (this.lastWordIndex < 0) {
            this.lastWordIndex = 0;
            this.words[0] = fillType | length - 1;
            return;
        }
        int lastWord = this.words[this.lastWordIndex];
        if (ConciseSet.isLiteral(lastWord)) {
            if (fillType == 0 && lastWord == Integer.MIN_VALUE) {
                this.words[this.lastWordIndex] = length;
            } else if (fillType == 0x40000000 && lastWord == -1) {
                this.words[this.lastWordIndex] = 0x40000000 | length;
            } else if (!this.simulateWAH) {
                if (fillType == 0 && ConciseSet.containsOnlyOneBit(ConciseSet.getLiteralBits(lastWord))) {
                    this.words[this.lastWordIndex] = length | 1 + Integer.numberOfTrailingZeros(lastWord) << 25;
                } else if (fillType == 0x40000000 && ConciseSet.containsOnlyOneBit(~lastWord)) {
                    this.words[this.lastWordIndex] = 0x40000000 | length | 1 + Integer.numberOfTrailingZeros(~lastWord) << 25;
                } else {
                    this.words[++this.lastWordIndex] = fillType | length - 1;
                }
            } else {
                this.words[++this.lastWordIndex] = fillType | length - 1;
            }
        } else if ((lastWord & 0xC0000000) == fillType) {
            int n = this.lastWordIndex;
            this.words[n] = this.words[n] + length;
        } else {
            this.words[++this.lastWordIndex] = fillType | length - 1;
        }
    }

    private void updateLast() {
        if (this.isEmpty()) {
            this.last = -1;
            return;
        }
        this.last = 0;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            int w = this.words[i];
            if (ConciseSet.isLiteral(w)) {
                this.last += 31;
                continue;
            }
            this.last += ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(w) + 1);
        }
        int w = this.words[this.lastWordIndex];
        this.last = ConciseSet.isLiteral(w) ? (this.last -= Integer.numberOfLeadingZeros(ConciseSet.getLiteralBits(w))) : --this.last;
    }

    private ConciseSet performOperation(ConciseSet other, Operator operator) {
        if (this.isEmpty() || other.isEmpty()) {
            return operator.combineEmptySets(this, other);
        }
        ConciseSet res = operator.combineDisjointSets(this, other);
        if (res != null) {
            return res;
        }
        res = this.empty();
        res.words = new int[1 + Math.min(this.lastWordIndex + other.lastWordIndex + 2, ConciseSet.maxLiteralLengthDivision(Math.max(this.last, other.last)) << (this.simulateWAH ? 1 : 0))];
        WordIterator thisItr = new WordIterator();
        WordIterator otherItr = other.new WordIterator();
        while (true) {
            if (!thisItr.isLiteral) {
                if (!otherItr.isLiteral) {
                    int minCount = Math.min(thisItr.count, otherItr.count);
                    res.appendFill(minCount, operator.combineLiterals(thisItr.word, otherItr.word));
                    if (!(!thisItr.prepareNext(minCount) | !otherItr.prepareNext(minCount))) continue;
                    break;
                }
                res.appendLiteral(operator.combineLiterals(thisItr.toLiteral(), otherItr.word));
                --thisItr.word;
                if (!(!thisItr.prepareNext(1) | !otherItr.prepareNext())) continue;
                break;
            }
            if (!otherItr.isLiteral) {
                res.appendLiteral(operator.combineLiterals(thisItr.word, otherItr.toLiteral()));
                --otherItr.word;
                if (!(!thisItr.prepareNext() | !otherItr.prepareNext(1))) continue;
                break;
            }
            res.appendLiteral(operator.combineLiterals(thisItr.word, otherItr.word));
            if (!thisItr.prepareNext() | !otherItr.prepareNext()) break;
        }
        res.size = -1;
        boolean invalidLast = true;
        switch (operator) {
            case AND: {
                break;
            }
            case OR: {
                res.last = Math.max(this.last, other.last);
                invalidLast = false;
                invalidLast |= thisItr.flush(res);
                invalidLast |= otherItr.flush(res);
                break;
            }
            case XOR: {
                if (this.last != other.last) {
                    res.last = Math.max(this.last, other.last);
                    invalidLast = false;
                }
                invalidLast |= thisItr.flush(res);
                invalidLast |= otherItr.flush(res);
                break;
            }
            case ANDNOT: {
                if (this.last > other.last) {
                    res.last = this.last;
                    invalidLast = false;
                }
                invalidLast |= thisItr.flush(res);
            }
        }
        res.trimZeros();
        if (res.isEmpty()) {
            return res;
        }
        if (invalidLast) {
            res.updateLast();
        }
        res.compact();
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int intersectionSize(IntSet o) {
        if (this.isEmpty() || o == null || o.isEmpty()) {
            return 0;
        }
        if (this == o) {
            return this.size();
        }
        ConciseSet other = this.convert(o);
        if (ConciseSet.isSequenceWithNoBits(this.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(this.words[0]) + 1) > other.last) {
            if (!ConciseSet.isZeroSequence(this.words[0])) return other.size();
            return 0;
        }
        if (ConciseSet.isSequenceWithNoBits(other.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(other.words[0]) + 1) > this.last) {
            if (!ConciseSet.isZeroSequence(other.words[0])) return this.size();
            return 0;
        }
        int res = 0;
        WordIterator thisItr = new WordIterator();
        WordIterator otherItr = other.new WordIterator();
        while (true) {
            if (!thisItr.isLiteral) {
                if (!otherItr.isLiteral) {
                    int minCount = Math.min(thisItr.count, otherItr.count);
                    if ((0x40000000 & thisItr.word & otherItr.word) != 0) {
                        res += ConciseSet.maxLiteralLengthMultiplication(minCount);
                    }
                    if (!(!thisItr.prepareNext(minCount) | !otherItr.prepareNext(minCount))) continue;
                    return res;
                }
                res += ConciseSet.getLiteralBitCount(thisItr.toLiteral() & otherItr.word);
                --thisItr.word;
                if (!(!thisItr.prepareNext(1) | !otherItr.prepareNext())) continue;
                return res;
            }
            if (!otherItr.isLiteral) {
                res += ConciseSet.getLiteralBitCount(thisItr.word & otherItr.toLiteral());
                --otherItr.word;
                if (!(!thisItr.prepareNext() | !otherItr.prepareNext(1))) continue;
                return res;
            }
            res += ConciseSet.getLiteralBitCount(thisItr.word & otherItr.word);
            if (!thisItr.prepareNext() | !otherItr.prepareNext()) return res;
        }
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate((this.lastWordIndex + 1) * 4);
        buffer.asIntBuffer().put(Arrays.copyOf(this.words, this.lastWordIndex + 1));
        return buffer;
    }

    public int[] getWords() {
        return Arrays.copyOf(this.words, this.lastWordIndex + 1);
    }

    @Override
    public int get(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException();
        }
        int firstSetBitInWord = 0;
        int position = i;
        int setBitsInCurrentWord = 0;
        for (int j = 0; j <= this.lastWordIndex; ++j) {
            int w = this.words[j];
            if (ConciseSet.isLiteral(w)) {
                setBitsInCurrentWord = ConciseSet.getLiteralBitCount(w);
                if (position < setBitsInCurrentWord) {
                    int currSetBitInWord = -1;
                    while (position >= 0) {
                        currSetBitInWord = Integer.numberOfTrailingZeros(w & -1 << currSetBitInWord + 1);
                        --position;
                    }
                    return firstSetBitInWord + currSetBitInWord;
                }
                firstSetBitInWord += 31;
            } else {
                int sequenceLength = ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(w) + 1);
                if (ConciseSet.isOneSequence(w)) {
                    if (this.simulateWAH || ConciseSet.isSequenceWithNoBits(w)) {
                        setBitsInCurrentWord = sequenceLength;
                        if (position < setBitsInCurrentWord) {
                            return firstSetBitInWord + position;
                        }
                    } else {
                        setBitsInCurrentWord = sequenceLength - 1;
                        if (position < setBitsInCurrentWord) {
                            return firstSetBitInWord + position + (position < ConciseSet.getFlippedBit(w) ? 0 : 1);
                        }
                    }
                } else if (this.simulateWAH || ConciseSet.isSequenceWithNoBits(w)) {
                    setBitsInCurrentWord = 0;
                } else {
                    setBitsInCurrentWord = 1;
                    if (position == 0) {
                        return firstSetBitInWord + ConciseSet.getFlippedBit(w);
                    }
                }
                firstSetBitInWord += sequenceLength;
            }
            position -= setBitsInCurrentWord;
        }
        throw new IndexOutOfBoundsException(Integer.toString(i));
    }

    @Override
    public int indexOf(int e) {
        if (e < 0) {
            throw new IllegalArgumentException("positive integer expected: " + Integer.toString(e));
        }
        if (this.isEmpty()) {
            return -1;
        }
        int index = 0;
        int blockIndex = ConciseSet.maxLiteralLengthDivision(e);
        int bitPosition = ConciseSet.maxLiteralLengthModulus(e);
        for (int i = 0; i <= this.lastWordIndex && blockIndex >= 0; ++i) {
            int w = this.words[i];
            if (ConciseSet.isLiteral(w)) {
                if (blockIndex == 0) {
                    if ((w & 1 << bitPosition) == 0) {
                        return -1;
                    }
                    return index + BitCount.count(w & ~(-1 << bitPosition));
                }
                --blockIndex;
                index += ConciseSet.getLiteralBitCount(w);
                continue;
            }
            if (this.simulateWAH) {
                if (ConciseSet.isOneSequence(w) && blockIndex <= ConciseSet.getSequenceCount(w)) {
                    return index + ConciseSet.maxLiteralLengthMultiplication(blockIndex) + bitPosition;
                }
            } else {
                if (blockIndex == 0) {
                    int l = this.getLiteral(w);
                    if ((l & 1 << bitPosition) == 0) {
                        return -1;
                    }
                    return index + BitCount.count(l & ~(-1 << bitPosition));
                }
                if (blockIndex > 0 && blockIndex <= ConciseSet.getSequenceCount(w) && ConciseSet.isOneSequence(w)) {
                    return index + ConciseSet.maxLiteralLengthMultiplication(blockIndex) + bitPosition - (ConciseSet.isSequenceWithNoBits(w) ? 0 : 1);
                }
            }
            int blocks = ConciseSet.getSequenceCount(w) + 1;
            blockIndex -= blocks;
            if (ConciseSet.isZeroSequence(w)) {
                if (this.simulateWAH || ConciseSet.isSequenceWithNoBits(w)) continue;
                ++index;
                continue;
            }
            index += ConciseSet.maxLiteralLengthMultiplication(blocks);
            if (this.simulateWAH || ConciseSet.isSequenceWithNoBits(w)) continue;
            --index;
        }
        return -1;
    }

    @Override
    public ConciseSet intersection(IntSet other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return this.empty();
        }
        if (other == this) {
            return this.clone();
        }
        return this.performOperation(this.convert(other), Operator.AND);
    }

    @Override
    public ConciseSet union(IntSet other) {
        if (other == null || other.isEmpty() || other == this) {
            return this.clone();
        }
        return this.performOperation(this.convert(other), Operator.OR);
    }

    @Override
    public ConciseSet difference(IntSet other) {
        if (other == this) {
            return this.empty();
        }
        if (other == null || other.isEmpty()) {
            return this.clone();
        }
        return this.performOperation(this.convert(other), Operator.ANDNOT);
    }

    @Override
    public ConciseSet symmetricDifference(IntSet other) {
        if (other == this) {
            return this.empty();
        }
        if (other == null || other.isEmpty()) {
            return this.clone();
        }
        return this.performOperation(this.convert(other), Operator.XOR);
    }

    @Override
    public ConciseSet complemented() {
        ConciseSet cloned = this.clone();
        cloned.complement();
        return cloned;
    }

    @Override
    public void complement() {
        ++this.modCount;
        if (this.isEmpty()) {
            return;
        }
        if (this.last == 0) {
            this.clear();
            return;
        }
        if (this.size >= 0) {
            this.size = this.last - this.size + 1;
        }
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            int w = this.words[i];
            if (ConciseSet.isLiteral(w)) {
                this.words[i] = Integer.MIN_VALUE | ~w;
                continue;
            }
            int n = i;
            this.words[n] = this.words[n] ^ 0x40000000;
        }
        if (ConciseSet.isLiteral(this.words[this.lastWordIndex])) {
            this.clearBitsAfterInLastWord(ConciseSet.maxLiteralLengthModulus(this.last));
        }
        this.trimZeros();
        if (this.isEmpty()) {
            return;
        }
        this.last = 0;
        int w = 0;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            w = this.words[i];
            if (ConciseSet.isLiteral(w)) {
                this.last += 31;
                continue;
            }
            this.last += ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(w) + 1);
        }
        this.last = ConciseSet.isLiteral(w) ? (this.last -= Integer.numberOfLeadingZeros(ConciseSet.getLiteralBits(w))) : --this.last;
    }

    private void trimZeros() {
        do {
            int w;
            if ((w = this.words[this.lastWordIndex]) == Integer.MIN_VALUE) {
                --this.lastWordIndex;
                continue;
            }
            if (ConciseSet.isZeroSequence(w)) {
                if (this.simulateWAH || ConciseSet.isSequenceWithNoBits(w)) {
                    --this.lastWordIndex;
                    continue;
                }
                this.words[this.lastWordIndex] = this.getLiteral(w);
                return;
            }
            return;
        } while (this.lastWordIndex >= 0);
        this.reset();
    }

    @Override
    public IntSet.IntIterator iterator() {
        if (this.isEmpty()) {
            return new IntSet.IntIterator(){

                @Override
                public void skipAllBefore(int element) {
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public IntSet.IntIterator clone() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new BitIterator();
    }

    @Override
    public IntSet.IntIterator descendingIterator() {
        if (this.isEmpty()) {
            return new IntSet.IntIterator(){

                @Override
                public void skipAllBefore(int element) {
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public IntSet.IntIterator clone() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new ReverseBitIterator();
    }

    @Override
    public void clear() {
        this.reset();
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.last;
    }

    private ConciseSet convert(IntSet c) {
        if (c instanceof ConciseSet && this.simulateWAH == ((ConciseSet)c).simulateWAH) {
            return (ConciseSet)c;
        }
        if (c == null) {
            return this.empty();
        }
        ConciseSet res = this.empty();
        IntSet.IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            res.add(itr.next());
        }
        return res;
    }

    @Override
    public ConciseSet convert(int ... a) {
        ConciseSet res = this.empty();
        if (a != null) {
            a = Arrays.copyOf(a, a.length);
            Arrays.sort(a);
            for (int i : a) {
                if (res.last == i) continue;
                res.add(i);
            }
        }
        return res;
    }

    @Override
    public ConciseSet convert(Collection<Integer> c) {
        ConciseSet res = this.empty();
        if (c != null) {
            Collection<Integer> sorted;
            if (c instanceof SortedSet && ((SortedSet)c).comparator() == null) {
                sorted = c;
            } else {
                sorted = new ArrayList<Integer>(c);
                Collections.sort((List)sorted);
            }
            for (int i : sorted) {
                if (res.last == i) continue;
                res.add(i);
            }
        }
        return res;
    }

    private boolean replaceWith(ConciseSet other) {
        if (this == other) {
            return false;
        }
        boolean isSimilar = this.lastWordIndex == other.lastWordIndex && this.last == other.last;
        for (int i = 0; isSimilar && i <= this.lastWordIndex; isSimilar &= this.words[i] == other.words[i], ++i) {
        }
        if (isSimilar) {
            if (other.size >= 0) {
                this.size = other.size;
            }
            return false;
        }
        this.words = other.words;
        this.size = other.size;
        this.last = other.last;
        this.lastWordIndex = other.lastWordIndex;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean add(int e) {
        ++this.modCount;
        if (e < 0 || e > 1040187422) {
            throw new IndexOutOfBoundsException(String.valueOf(e));
        }
        if (e > this.last) {
            this.append(e);
            return true;
        }
        if (e == this.last) {
            return false;
        }
        int blockIndex = ConciseSet.maxLiteralLengthDivision(e);
        int bitPosition = ConciseSet.maxLiteralLengthModulus(e);
        for (int i = 0; i <= this.lastWordIndex && blockIndex >= 0; ++i) {
            int w = this.words[i];
            if (ConciseSet.isLiteral(w)) {
                if (blockIndex == 0) {
                    int bitCount;
                    if ((w & 1 << bitPosition) != 0) {
                        return false;
                    }
                    if (!this.simulateWAH ? (bitCount = ConciseSet.getLiteralBitCount(w)) >= 29 : ConciseSet.containsOnlyOneBit(~w) || w == -1) break;
                    int n = i;
                    this.words[n] = this.words[n] | 1 << bitPosition;
                    if (this.size >= 0) {
                        ++this.size;
                    }
                    return true;
                }
                --blockIndex;
                continue;
            }
            if (this.simulateWAH) {
                if (ConciseSet.isOneSequence(w) && blockIndex <= ConciseSet.getSequenceCount(w)) {
                    return false;
                }
            } else {
                if (blockIndex == 0 && (this.getLiteral(w) & 1 << bitPosition) != 0) {
                    return false;
                }
                if (blockIndex > 0 && blockIndex <= ConciseSet.getSequenceCount(w) && ConciseSet.isOneSequence(w)) {
                    return false;
                }
            }
            blockIndex -= ConciseSet.getSequenceCount(w) + 1;
        }
        return this.replaceWith(this.performOperation(this.convert(e), Operator.OR));
    }

    @Override
    public boolean remove(int o) {
        ++this.modCount;
        if (this.isEmpty()) {
            return false;
        }
        if (o > this.last) {
            return false;
        }
        int blockIndex = ConciseSet.maxLiteralLengthDivision(o);
        int bitPosition = ConciseSet.maxLiteralLengthModulus(o);
        for (int i = 0; i <= this.lastWordIndex && blockIndex >= 0; ++i) {
            int w = this.words[i];
            if (ConciseSet.isLiteral(w)) {
                if (blockIndex == 0) {
                    int l;
                    int bitCount;
                    if ((w & 1 << bitPosition) == 0) {
                        return false;
                    }
                    if (!this.simulateWAH ? (bitCount = ConciseSet.getLiteralBitCount(w)) <= 2 : (l = ConciseSet.getLiteralBits(w)) == 0 || ConciseSet.containsOnlyOneBit(l)) break;
                    int n = i;
                    this.words[n] = this.words[n] & ~(1 << bitPosition);
                    if (this.size >= 0) {
                        --this.size;
                    }
                    if (o == this.last) {
                        this.last -= ConciseSet.maxLiteralLengthModulus(this.last) - (31 - Integer.numberOfLeadingZeros(ConciseSet.getLiteralBits(this.words[i])));
                    }
                    return true;
                }
                --blockIndex;
                continue;
            }
            if (this.simulateWAH) {
                if (ConciseSet.isZeroSequence(w) && blockIndex <= ConciseSet.getSequenceCount(w)) {
                    return false;
                }
            } else {
                if (blockIndex == 0 && (this.getLiteral(w) & 1 << bitPosition) == 0) {
                    return false;
                }
                if (blockIndex > 0 && blockIndex <= ConciseSet.getSequenceCount(w) && ConciseSet.isZeroSequence(w)) {
                    return false;
                }
            }
            blockIndex -= ConciseSet.getSequenceCount(w) + 1;
        }
        return this.replaceWith(this.performOperation(this.convert(o), Operator.ANDNOT));
    }

    @Override
    public boolean contains(int o) {
        if (this.isEmpty() || o > this.last || o < 0) {
            return false;
        }
        int block = ConciseSet.maxLiteralLengthDivision(o);
        int bit = ConciseSet.maxLiteralLengthModulus(o);
        block5: for (int i = 0; i <= this.lastWordIndex; ++i) {
            int w = this.words[i];
            int t = w & 0xC0000000;
            switch (t) {
                case -2147483648: 
                case -1073741824: {
                    if (block == 0) {
                        return (w & 1 << bit) != 0;
                    }
                    --block;
                    continue block5;
                }
                case 0: {
                    if (!this.simulateWAH && block == 0 && (w >> 25) - 1 == bit) {
                        return true;
                    }
                    if ((block -= ConciseSet.getSequenceCount(w) + 1) >= 0) continue block5;
                    return false;
                }
                case 0x40000000: {
                    if (!this.simulateWAH && block == 0 && (0x1F & (w >> 25) - 1) == bit) {
                        return false;
                    }
                    if ((block -= ConciseSet.getSequenceCount(w) + 1) >= 0) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(IntSet c) {
        if (c == null || c.isEmpty() || c == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        ConciseSet other = this.convert(c);
        if (other.last > this.last) {
            return false;
        }
        if (this.size >= 0 && other.size > this.size) {
            return false;
        }
        if (other.size == 1) {
            return this.contains(other.last);
        }
        if (ConciseSet.isSequenceWithNoBits(this.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(this.words[0]) + 1) > other.last) {
            return !ConciseSet.isZeroSequence(this.words[0]);
        }
        if (ConciseSet.isSequenceWithNoBits(other.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(other.words[0]) + 1) > this.last) {
            return false;
        }
        WordIterator thisItr = new WordIterator();
        WordIterator otherItr = other.new WordIterator();
        while (true) {
            if (!thisItr.isLiteral) {
                if (!otherItr.isLiteral) {
                    int minCount = Math.min(thisItr.count, otherItr.count);
                    if ((0x40000000 & thisItr.word) == 0 && (0x40000000 & otherItr.word) != 0) {
                        return false;
                    }
                    if (!otherItr.prepareNext(minCount)) {
                        return true;
                    }
                    if (thisItr.prepareNext(minCount)) continue;
                    return false;
                }
                if ((thisItr.toLiteral() & otherItr.word) != otherItr.word) {
                    return false;
                }
                --thisItr.word;
                if (!otherItr.prepareNext()) {
                    return true;
                }
                if (thisItr.prepareNext(1)) continue;
                return false;
            }
            if (!otherItr.isLiteral) {
                int o = otherItr.toLiteral();
                if ((thisItr.word & otherItr.toLiteral()) != o) {
                    return false;
                }
                --otherItr.word;
                if (!otherItr.prepareNext(1)) {
                    return true;
                }
                if (thisItr.prepareNext()) continue;
                return false;
            }
            if ((thisItr.word & otherItr.word) != otherItr.word) {
                return false;
            }
            if (!otherItr.prepareNext()) {
                return true;
            }
            if (!thisItr.prepareNext()) break;
        }
        return false;
    }

    @Override
    public boolean containsAny(IntSet c) {
        if (c == null || c.isEmpty() || c == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        ConciseSet other = this.convert(c);
        if (other.size == 1) {
            return this.contains(other.last);
        }
        if (ConciseSet.isSequenceWithNoBits(this.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(this.words[0]) + 1) > other.last) {
            return !ConciseSet.isZeroSequence(this.words[0]);
        }
        if (ConciseSet.isSequenceWithNoBits(other.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(other.words[0]) + 1) > this.last) {
            return !ConciseSet.isZeroSequence(other.words[0]);
        }
        WordIterator thisItr = new WordIterator();
        WordIterator otherItr = other.new WordIterator();
        while (true) {
            if (!thisItr.isLiteral) {
                if (!otherItr.isLiteral) {
                    int minCount = Math.min(thisItr.count, otherItr.count);
                    if ((0x40000000 & thisItr.word & otherItr.word) != 0) {
                        return true;
                    }
                    if (!(!thisItr.prepareNext(minCount) | !otherItr.prepareNext(minCount))) continue;
                    return false;
                }
                if ((thisItr.toLiteral() & otherItr.word) != Integer.MIN_VALUE) {
                    return true;
                }
                --thisItr.word;
                if (!(!thisItr.prepareNext(1) | !otherItr.prepareNext())) continue;
                return false;
            }
            if (!otherItr.isLiteral) {
                if ((thisItr.word & otherItr.toLiteral()) != Integer.MIN_VALUE) {
                    return true;
                }
                --otherItr.word;
                if (!(!thisItr.prepareNext() | !otherItr.prepareNext(1))) continue;
                return false;
            }
            if ((thisItr.word & otherItr.word) != Integer.MIN_VALUE) {
                return true;
            }
            if (!thisItr.prepareNext() | !otherItr.prepareNext()) break;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(IntSet c, int minElements) {
        if (minElements < 1) {
            throw new IllegalArgumentException();
        }
        if (this.size >= 0 && this.size < minElements || c == null || c.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (this == c) {
            return this.size() >= minElements;
        }
        ConciseSet other = this.convert(c);
        if (other.size >= 0 && other.size < minElements) {
            return false;
        }
        if (minElements == 1 && other.size == 1) {
            return this.contains(other.last);
        }
        if (minElements == 1 && this.size == 1) {
            return other.contains(this.last);
        }
        if (ConciseSet.isSequenceWithNoBits(this.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(this.words[0]) + 1) > other.last) {
            return !ConciseSet.isZeroSequence(this.words[0]);
        }
        if (ConciseSet.isSequenceWithNoBits(other.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(other.words[0]) + 1) > this.last) {
            return !ConciseSet.isZeroSequence(other.words[0]);
        }
        int res = 0;
        WordIterator thisItr = new WordIterator();
        WordIterator otherItr = other.new WordIterator();
        while (true) {
            if (!thisItr.isLiteral) {
                if (!otherItr.isLiteral) {
                    int minCount = Math.min(thisItr.count, otherItr.count);
                    if ((0x40000000 & thisItr.word & otherItr.word) != 0 && (res += ConciseSet.maxLiteralLengthMultiplication(minCount)) >= minElements) {
                        return true;
                    }
                    if (!(!thisItr.prepareNext(minCount) | !otherItr.prepareNext(minCount))) continue;
                    return false;
                }
                if ((res += ConciseSet.getLiteralBitCount(thisItr.toLiteral() & otherItr.word)) >= minElements) {
                    return true;
                }
                --thisItr.word;
                if (!(!thisItr.prepareNext(1) | !otherItr.prepareNext())) continue;
                return false;
            }
            if (!otherItr.isLiteral) {
                if ((res += ConciseSet.getLiteralBitCount(thisItr.word & otherItr.toLiteral())) >= minElements) {
                    return true;
                }
                --otherItr.word;
                if (!(!thisItr.prepareNext() | !otherItr.prepareNext(1))) continue;
                return false;
            }
            if ((res += ConciseSet.getLiteralBitCount(thisItr.word & otherItr.word)) >= minElements) {
                return true;
            }
            if (!thisItr.prepareNext() | !otherItr.prepareNext()) break;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.words == null;
    }

    @Override
    public boolean retainAll(IntSet c) {
        ++this.modCount;
        if (this.isEmpty() || c == this) {
            return false;
        }
        if (c == null || c.isEmpty()) {
            this.clear();
            return true;
        }
        ConciseSet other = this.convert(c);
        if (other.size == 1) {
            if (this.contains(other.last)) {
                if (this.size == 1) {
                    return false;
                }
                return this.replaceWith(this.convert(other.last));
            }
            this.clear();
            return true;
        }
        return this.replaceWith(this.performOperation(other, Operator.AND));
    }

    @Override
    public boolean addAll(IntSet c) {
        ++this.modCount;
        if (c == null || c.isEmpty() || this == c) {
            return false;
        }
        ConciseSet other = this.convert(c);
        if (other.size == 1) {
            return this.add(other.last);
        }
        return this.replaceWith(this.performOperation(this.convert(c), Operator.OR));
    }

    @Override
    public boolean removeAll(IntSet c) {
        ++this.modCount;
        if (c == null || c.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (c == this) {
            this.clear();
            return true;
        }
        ConciseSet other = this.convert(c);
        if (other.size == 1) {
            return this.remove(other.last);
        }
        return this.replaceWith(this.performOperation(this.convert(c), Operator.ANDNOT));
    }

    @Override
    public int size() {
        if (this.size < 0) {
            this.size = 0;
            for (int i = 0; i <= this.lastWordIndex; ++i) {
                int w = this.words[i];
                if (ConciseSet.isLiteral(w)) {
                    this.size += ConciseSet.getLiteralBitCount(w);
                    continue;
                }
                if (ConciseSet.isZeroSequence(w)) {
                    if (ConciseSet.isSequenceWithNoBits(w)) continue;
                    ++this.size;
                    continue;
                }
                this.size += ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(w) + 1);
                if (ConciseSet.isSequenceWithNoBits(w)) continue;
                --this.size;
            }
        }
        return this.size;
    }

    @Override
    public ConciseSet empty() {
        return new ConciseSet(this.simulateWAH);
    }

    @Override
    public int hashCode() {
        int h = 1;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            h = (h << 5) - h + this.words[i];
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConciseSet)) {
            return super.equals(obj);
        }
        ConciseSet other = (ConciseSet)obj;
        if (this.simulateWAH != other.simulateWAH) {
            return super.equals(obj);
        }
        if (this.size() != other.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (this.last != other.last) {
            return false;
        }
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            if (this.words[i] == other.words[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(IntSet o) {
        if (this.isEmpty() && o.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (o.isEmpty()) {
            return 1;
        }
        ConciseSet other = this.convert(o);
        int res = this.last - other.last;
        if (res != 0) {
            return res < 0 ? -1 : 1;
        }
        int thisIndex = this.lastWordIndex;
        int otherIndex = other.lastWordIndex;
        int thisWord = this.words[thisIndex];
        int otherWord = other.words[otherIndex];
        while (thisIndex >= 0 && otherIndex >= 0) {
            if (!ConciseSet.isLiteral(thisWord)) {
                if (!ConciseSet.isLiteral(otherWord)) {
                    if (ConciseSet.isZeroSequence(thisWord)) {
                        if (ConciseSet.isOneSequence(otherWord)) {
                            return -1;
                        }
                        res = ConciseSet.getSequenceCount(otherWord) - ConciseSet.getSequenceCount(thisWord);
                        if (res != 0) {
                            return res < 0 ? -1 : 1;
                        }
                    } else {
                        if (ConciseSet.isZeroSequence(otherWord)) {
                            return 1;
                        }
                        res = ConciseSet.getSequenceCount(thisWord) - ConciseSet.getSequenceCount(otherWord);
                        if (res != 0) {
                            return res < 0 ? -1 : 1;
                        }
                    }
                    thisWord = this.getLiteral(thisWord);
                    otherWord = this.getLiteral(otherWord);
                    continue;
                }
                if (ConciseSet.isZeroSequence(thisWord)) {
                    if (otherWord != Integer.MIN_VALUE) {
                        return -1;
                    }
                } else if (otherWord != -1) {
                    return 1;
                }
                thisWord = ConciseSet.getSequenceCount(thisWord) == 1 ? this.getLiteral(thisWord) : --thisWord;
                if (--otherIndex < 0) continue;
                otherWord = other.words[otherIndex];
                continue;
            }
            if (!ConciseSet.isLiteral(otherWord)) {
                if (ConciseSet.isZeroSequence(otherWord)) {
                    if (thisWord != Integer.MIN_VALUE) {
                        return 1;
                    }
                } else if (thisWord != -1) {
                    return -1;
                }
                if (--thisIndex >= 0) {
                    thisWord = this.words[thisIndex];
                }
                if (ConciseSet.getSequenceCount(otherWord) == 1) {
                    otherWord = this.getLiteral(otherWord);
                    continue;
                }
                --otherWord;
                continue;
            }
            res = thisWord - otherWord;
            if (res != 0) {
                return res < 0 ? -1 : 1;
            }
            if (--thisIndex >= 0) {
                thisWord = this.words[thisIndex];
            }
            if (--otherIndex < 0) continue;
            otherWord = other.words[otherIndex];
        }
        return thisIndex >= 0 ? 1 : (otherIndex >= 0 ? -1 : 0);
    }

    @Override
    public void clear(int from, int to) {
        ConciseSet toRemove = this.empty();
        toRemove.fill(from, to);
        this.removeAll(toRemove);
    }

    @Override
    public void fill(int from, int to) {
        ConciseSet toAdd = this.empty();
        toAdd.add(to);
        toAdd.complement();
        toAdd.add(to);
        ConciseSet toRemove = this.empty();
        toRemove.add(from);
        toRemove.complement();
        toAdd.removeAll(toRemove);
        this.addAll(toAdd);
    }

    @Override
    public void flip(int e) {
        if (!this.add(e)) {
            this.remove(e);
        }
    }

    @Override
    public double bitmapCompressionRatio() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return (double)(this.lastWordIndex + 1) / Math.ceil((double)(1 + this.last) / 32.0);
    }

    @Override
    public double collectionCompressionRatio() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return (double)(this.lastWordIndex + 1) / (double)this.size();
    }

    private static String toBinaryString(int word) {
        String lsb = Integer.toBinaryString(word);
        StringBuilder pad = new StringBuilder();
        for (int i = lsb.length(); i < 32; ++i) {
            pad.append('0');
        }
        return pad.append(lsb).toString();
    }

    @Override
    public String debugInfo() {
        StringBuilder s = new StringBuilder("INTERNAL REPRESENTATION:\n");
        Formatter f = new Formatter(s, Locale.ENGLISH);
        if (this.isEmpty()) {
            return s.append("null\n").toString();
        }
        f.format("Elements: %s\n", this.toString());
        int firstBitInWord = 0;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            f.format("words[%d] = ", i);
            String ws = ConciseSet.toBinaryString(this.words[i]);
            if (ConciseSet.isLiteral(this.words[i])) {
                s.append(ws.substring(0, 1));
                s.append("--");
                s.append(ws.substring(1));
            } else {
                s.append(ws.substring(0, 2));
                s.append('-');
                if (this.simulateWAH) {
                    s.append("xxxxx");
                } else {
                    s.append(ws.substring(2, 7));
                }
                s.append('-');
                s.append(ws.substring(7));
            }
            s.append(" --> ");
            if (ConciseSet.isLiteral(this.words[i])) {
                s.append("literal: ");
                s.append(ConciseSet.toBinaryString(this.words[i]).substring(1));
                f.format(" ---> [from %d to %d] ", firstBitInWord, firstBitInWord + 31 - 1);
                firstBitInWord += 31;
            } else {
                if (ConciseSet.isOneSequence(this.words[i])) {
                    s.append('1');
                } else {
                    s.append('0');
                }
                s.append(" block: ");
                s.append(ConciseSet.toBinaryString(ConciseSet.getLiteralBits(this.getLiteral(this.words[i]))).substring(1));
                if (!this.simulateWAH) {
                    s.append(" (bit=");
                    int bit = (this.words[i] & 0x3E000000) >>> 25;
                    if (bit == 0) {
                        s.append("none");
                    } else {
                        s.append(String.format("%4d", bit - 1));
                    }
                    s.append(')');
                }
                int count = ConciseSet.getSequenceCount(this.words[i]);
                f.format(" followed by %d blocks (%d bits)", ConciseSet.getSequenceCount(this.words[i]), ConciseSet.maxLiteralLengthMultiplication(count));
                f.format(" ---> [from %d to %d] ", firstBitInWord, firstBitInWord + (count + 1) * 31 - 1);
                firstBitInWord += (count + 1) * 31;
            }
            s.append('\n');
        }
        f.format("simulateWAH: %b\n", this.simulateWAH);
        f.format("last: %d\n", this.last);
        f.format("size: %s\n", this.size == -1 ? "invalid" : Integer.toString(this.size));
        f.format("words.length: %d\n", this.words.length);
        f.format("lastWordIndex: %d\n", this.lastWordIndex);
        f.format("bitmap compression: %.2f%%\n", 100.0 * this.bitmapCompressionRatio());
        f.format("collection compression: %.2f%%\n", 100.0 * this.collectionCompressionRatio());
        return s.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.words != null && this.lastWordIndex < this.words.length - 1) {
            this.words = Arrays.copyOf(this.words, this.lastWordIndex + 1);
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.words == null) {
            this.reset();
            return;
        }
        this.lastWordIndex = this.words.length - 1;
        this.updateLast();
        this.size = -1;
    }

    static /* synthetic */ int[] access$102(ConciseSet x0, int[] x1) {
        x0.words = x1;
        return x1;
    }

    private class ReverseBitIterator
    implements IntSet.IntIterator {
        final LiteralAndZeroFillExpander litExp;
        final OneFillExpander oneExp;
        WordExpander exp;
        int nextIndex;
        int nextOffset;
        int firstIndex;

        void previousWord() {
            int word = ConciseSet.this.words[this.nextIndex--];
            WordExpander wordExpander = this.exp = ConciseSet.isOneSequence(word) ? this.oneExp : this.litExp;
            this.nextOffset = ConciseSet.isLiteral(word) ? (this.nextOffset -= 31) : (this.nextOffset -= ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(word) + 1));
            this.exp.reset(this.nextOffset, word, false);
        }

        ReverseBitIterator() {
            this.litExp = new LiteralAndZeroFillExpander();
            this.oneExp = new OneFillExpander();
            this.nextIndex = ConciseSet.this.lastWordIndex;
            this.nextOffset = ConciseSet.maxLiteralLengthMultiplication(ConciseSet.maxLiteralLengthDivision(ConciseSet.this.last) + 1);
            this.firstIndex = ConciseSet.isSequenceWithNoBits(ConciseSet.this.words[0]) && ConciseSet.isZeroSequence(ConciseSet.this.words[0]) || ConciseSet.isLiteral(ConciseSet.this.words[0]) && ConciseSet.this.words[0] == Integer.MIN_VALUE ? 1 : 0;
            this.previousWord();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= this.firstIndex || this.exp.hasPrevious();
        }

        @Override
        public int next() {
            while (!this.exp.hasPrevious()) {
                if (this.nextIndex < this.firstIndex) {
                    throw new NoSuchElementException();
                }
                this.previousWord();
            }
            return this.exp.previous();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skipAllBefore(int element) {
            while (true) {
                this.exp.skipAllAfter(element);
                if (this.exp.hasPrevious() || this.nextIndex < this.firstIndex) {
                    return;
                }
                this.previousWord();
            }
        }

        @Override
        public IntSet.IntIterator clone() {
            ReverseBitIterator retVal = new ReverseBitIterator();
            retVal.exp = this.exp;
            retVal.nextIndex = this.nextIndex;
            retVal.nextOffset = this.nextOffset;
            retVal.firstIndex = this.firstIndex;
            return retVal;
        }
    }

    private class BitIterator
    implements IntSet.IntIterator {
        final LiteralAndZeroFillExpander litExp;
        final OneFillExpander oneExp;
        WordExpander exp;
        int nextIndex;
        int nextOffset;

        private void nextWord() {
            int word = ConciseSet.this.words[this.nextIndex++];
            this.exp = ConciseSet.isOneSequence(word) ? this.oneExp : this.litExp;
            this.exp.reset(this.nextOffset, word, true);
            this.nextOffset = ConciseSet.isLiteral(word) ? (this.nextOffset += 31) : (this.nextOffset += ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(word) + 1));
        }

        private BitIterator() {
            this.litExp = new LiteralAndZeroFillExpander();
            this.oneExp = new OneFillExpander();
            this.nextIndex = 0;
            this.nextOffset = 0;
            this.nextWord();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex <= ConciseSet.this.lastWordIndex || this.exp.hasNext();
        }

        @Override
        public int next() {
            while (!this.exp.hasNext()) {
                if (this.nextIndex > ConciseSet.this.lastWordIndex) {
                    throw new NoSuchElementException();
                }
                this.nextWord();
            }
            return this.exp.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skipAllBefore(int element) {
            while (true) {
                this.exp.skipAllBefore(element);
                if (this.exp.hasNext() || this.nextIndex > ConciseSet.this.lastWordIndex) {
                    return;
                }
                this.nextWord();
            }
        }

        @Override
        public IntSet.IntIterator clone() {
            BitIterator retVal = new BitIterator();
            retVal.exp = this.exp;
            retVal.nextIndex = this.nextIndex;
            retVal.nextOffset = this.nextOffset;
            return retVal;
        }
    }

    private class OneFillExpander
    implements WordExpander {
        int firstInt = 1;
        int lastInt = -1;
        int current = 0;
        int exception = -1;

        private OneFillExpander() {
        }

        @Override
        public boolean hasNext() {
            return this.current < this.lastInt;
        }

        @Override
        public boolean hasPrevious() {
            return this.current > this.firstInt;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.current;
            if (!ConciseSet.this.simulateWAH && this.current == this.exception) {
                ++this.current;
            }
            return this.current;
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.current;
            if (!ConciseSet.this.simulateWAH && this.current == this.exception) {
                --this.current;
            }
            return this.current;
        }

        @Override
        public void skipAllAfter(int i) {
            if (i >= this.current) {
                return;
            }
            this.current = i + 1;
        }

        @Override
        public void skipAllBefore(int i) {
            if (i <= this.current) {
                return;
            }
            this.current = i - 1;
        }

        @Override
        public void reset(int offset, int word, boolean fromBeginning) {
            if (!ConciseSet.isOneSequence(word)) {
                throw new RuntimeException("NOT a sequence of ones!");
            }
            this.firstInt = offset;
            this.lastInt = offset + ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(word) + 1) - 1;
            if (!ConciseSet.this.simulateWAH) {
                this.exception = offset + ((0x3FFFFFFF & word) >>> 25) - 1;
                if (this.exception == this.firstInt) {
                    ++this.firstInt;
                }
                if (this.exception == this.lastInt) {
                    --this.lastInt;
                }
            }
            this.current = fromBeginning ? this.firstInt - 1 : this.lastInt + 1;
        }
    }

    private class LiteralAndZeroFillExpander
    implements WordExpander {
        final int[] buffer = new int[31];
        int len = 0;
        int current = 0;

        private LiteralAndZeroFillExpander() {
        }

        @Override
        public boolean hasNext() {
            return this.current < this.len;
        }

        @Override
        public boolean hasPrevious() {
            return this.current > 0;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.buffer[this.current++];
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.buffer[--this.current];
        }

        @Override
        public void skipAllAfter(int i) {
            while (this.hasPrevious() && this.buffer[this.current - 1] > i) {
                --this.current;
            }
        }

        @Override
        public void skipAllBefore(int i) {
            while (this.hasNext() && this.buffer[this.current] < i) {
                ++this.current;
            }
        }

        @Override
        public void reset(int offset, int word, boolean fromBeginning) {
            if (ConciseSet.isLiteral(word)) {
                this.len = 0;
                for (int i = 0; i < 31; ++i) {
                    if ((word & 1 << i) == 0) continue;
                    this.buffer[this.len++] = offset + i;
                }
                this.current = fromBeginning ? 0 : this.len;
            } else if (ConciseSet.isZeroSequence(word)) {
                if (ConciseSet.this.simulateWAH || ConciseSet.isSequenceWithNoBits(word)) {
                    this.len = 0;
                    this.current = 0;
                } else {
                    this.len = 1;
                    this.buffer[0] = offset + ((0x3FFFFFFF & word) >>> 25) - 1;
                    this.current = fromBeginning ? 0 : 1;
                }
            } else {
                throw new RuntimeException("sequence of ones!");
            }
        }
    }

    private static interface WordExpander {
        public boolean hasNext();

        public boolean hasPrevious();

        public int next();

        public int previous();

        public void skipAllAfter(int var1);

        public void skipAllBefore(int var1);

        public void reset(int var1, int var2, boolean var3);
    }

    private class WordIterator {
        int word;
        int index = -1;
        boolean isLiteral = false;
        int count;

        WordIterator() {
            this.prepareNext();
        }

        boolean exhausted() {
            return this.index > ConciseSet.this.lastWordIndex;
        }

        boolean prepareNext(int c) {
            assert (c <= this.count);
            this.count -= c;
            if (this.count == 0) {
                return this.prepareNext();
            }
            return true;
        }

        boolean prepareNext() {
            if (!ConciseSet.this.simulateWAH && this.isLiteral && this.count > 1) {
                --this.count;
                this.isLiteral = false;
                this.word = ConciseSet.getSequenceWithNoBits(ConciseSet.this.words[this.index]) - 1;
                return true;
            }
            ++this.index;
            if (this.index > ConciseSet.this.lastWordIndex) {
                return false;
            }
            this.word = ConciseSet.this.words[this.index];
            this.isLiteral = ConciseSet.isLiteral(this.word);
            if (!this.isLiteral) {
                this.count = ConciseSet.getSequenceCount(this.word) + 1;
                if (!ConciseSet.this.simulateWAH && !ConciseSet.isSequenceWithNoBits(this.word)) {
                    this.isLiteral = true;
                    int bit = 1 << (this.word >>> 25) >>> 1;
                    this.word = ConciseSet.isZeroSequence(this.word) ? Integer.MIN_VALUE | bit : 0xFFFFFFFF & ~bit;
                }
            } else {
                this.count = 1;
            }
            return true;
        }

        int toLiteral() {
            assert (!this.isLiteral);
            return Integer.MIN_VALUE | this.word << 1 >> 31;
        }

        private boolean flush(ConciseSet s) {
            if (this.exhausted()) {
                return false;
            }
            do {
                if (this.isLiteral) {
                    s.appendLiteral(this.word);
                    continue;
                }
                s.appendFill(this.count, this.word);
            } while (this.prepareNext() && s.words[s.lastWordIndex] != this.word);
            int delta = ConciseSet.this.lastWordIndex - this.index + 1;
            System.arraycopy(ConciseSet.this.words, this.index, s.words, s.lastWordIndex + 1, delta);
            s.lastWordIndex += delta;
            s.last = ConciseSet.this.last;
            return true;
        }
    }

    private static enum Operator {
        AND{

            @Override
            public int combineLiterals(int literal1, int literal2) {
                return literal1 & literal2;
            }

            @Override
            public ConciseSet combineEmptySets(ConciseSet op1, ConciseSet op2) {
                return op1.empty();
            }

            private ConciseSet oneWayCombineDisjointSets(ConciseSet op1, ConciseSet op2) {
                if (ConciseSet.isSequenceWithNoBits(op1.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(op1.words[0]) + 1) > op2.last) {
                    if (ConciseSet.isZeroSequence(op1.words[0])) {
                        return op1.empty();
                    }
                    return op2.clone();
                }
                return null;
            }

            @Override
            public ConciseSet combineDisjointSets(ConciseSet op1, ConciseSet op2) {
                ConciseSet res = this.oneWayCombineDisjointSets(op1, op2);
                if (res == null) {
                    res = this.oneWayCombineDisjointSets(op2, op1);
                }
                return res;
            }
        }
        ,
        OR{

            @Override
            public int combineLiterals(int literal1, int literal2) {
                return literal1 | literal2;
            }

            @Override
            public ConciseSet combineEmptySets(ConciseSet op1, ConciseSet op2) {
                if (!op1.isEmpty()) {
                    return op1.clone();
                }
                if (!op2.isEmpty()) {
                    return op2.clone();
                }
                return op1.empty();
            }

            private ConciseSet oneWayCombineDisjointSets(ConciseSet op1, ConciseSet op2) {
                if (ConciseSet.isSequenceWithNoBits(op1.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(op1.words[0]) + 1) > op2.last) {
                    if (ConciseSet.isOneSequence(op1.words[0])) {
                        return op1.clone();
                    }
                    ConciseSet res = op1.empty();
                    ConciseSet.access$102(res, new int[op1.lastWordIndex + op2.lastWordIndex + 3]);
                    res.lastWordIndex = op2.lastWordIndex;
                    System.arraycopy(op2.words, 0, res.words, 0, op2.lastWordIndex + 1);
                    WordIterator wordIterator = op1.new WordIterator();
                    wordIterator.prepareNext(ConciseSet.maxLiteralLengthDivision(op2.last) + 1);
                    wordIterator.flush(res);
                    if (op1.size < 0 || op2.size < 0) {
                        res.size = -1;
                    } else {
                        res.size = op1.size + op2.size;
                    }
                    res.last = op1.last;
                    res.compact();
                    return res;
                }
                return null;
            }

            @Override
            public ConciseSet combineDisjointSets(ConciseSet op1, ConciseSet op2) {
                ConciseSet res = this.oneWayCombineDisjointSets(op1, op2);
                if (res == null) {
                    res = this.oneWayCombineDisjointSets(op2, op1);
                }
                return res;
            }
        }
        ,
        XOR{

            @Override
            public int combineLiterals(int literal1, int literal2) {
                return Integer.MIN_VALUE | literal1 ^ literal2;
            }

            @Override
            public ConciseSet combineEmptySets(ConciseSet op1, ConciseSet op2) {
                if (!op1.isEmpty()) {
                    return op1.clone();
                }
                if (!op2.isEmpty()) {
                    return op2.clone();
                }
                return op1.empty();
            }

            private ConciseSet oneWayCombineDisjointSets(ConciseSet op1, ConciseSet op2) {
                if (ConciseSet.isSequenceWithNoBits(op1.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(op1.words[0]) + 1) > op2.last) {
                    if (ConciseSet.isZeroSequence(op1.words[0])) {
                        return OR.combineDisjointSets(op1, op2);
                    }
                    return null;
                }
                return null;
            }

            @Override
            public ConciseSet combineDisjointSets(ConciseSet op1, ConciseSet op2) {
                ConciseSet res = this.oneWayCombineDisjointSets(op1, op2);
                if (res == null) {
                    res = this.oneWayCombineDisjointSets(op2, op1);
                }
                return res;
            }
        }
        ,
        ANDNOT{

            @Override
            public int combineLiterals(int literal1, int literal2) {
                return Integer.MIN_VALUE | literal1 & ~literal2;
            }

            @Override
            public ConciseSet combineEmptySets(ConciseSet op1, ConciseSet op2) {
                if (!op1.isEmpty()) {
                    return op1.clone();
                }
                return op1.empty();
            }

            @Override
            public ConciseSet combineDisjointSets(ConciseSet op1, ConciseSet op2) {
                if (ConciseSet.isSequenceWithNoBits(op1.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(op1.words[0]) + 1) > op2.last) {
                    if (ConciseSet.isZeroSequence(op1.words[0])) {
                        return op1.clone();
                    }
                    return null;
                }
                if (ConciseSet.isSequenceWithNoBits(op2.words[0]) && ConciseSet.maxLiteralLengthMultiplication(ConciseSet.getSequenceCount(op2.words[0]) + 1) > op1.last) {
                    if (ConciseSet.isZeroSequence(op2.words[0])) {
                        return op1.clone();
                    }
                    return op1.empty();
                }
                return null;
            }
        };


        public abstract int combineLiterals(int var1, int var2);

        public abstract ConciseSet combineEmptySets(ConciseSet var1, ConciseSet var2);

        public abstract ConciseSet combineDisjointSets(ConciseSet var1, ConciseSet var2);
    }
}

