/*
 * Decompiled with CFR 0.152.
 */
package io.druid.initialization;

import io.druid.initialization.LogLevelAdjusterMBean;
import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LogLevelAdjuster
implements LogLevelAdjusterMBean {
    private static final Logger log = Logger.getLogger(LogLevelAdjuster.class);
    private static volatile boolean registered = false;

    public static synchronized void register() throws Exception {
        if (!registered) {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new LogLevelAdjuster(), new ObjectName("log4j:name=log4j"));
            registered = true;
        }
    }

    @Override
    public String getLevel(String packageName) {
        Level level = Logger.getLogger((String)packageName).getEffectiveLevel();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Asked to look up level for package[%s] => [%s]", packageName, level));
        }
        return level.toString();
    }

    @Override
    public void setLevel(String packageName, String level) {
        Level theLevel = Level.toLevel((String)level, null);
        if (theLevel == null) {
            throw new IllegalArgumentException("Unknown level: " + level);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Setting log level for package[%s] => [%s]", packageName, theLevel));
        }
        Logger.getLogger((String)packageName).setLevel(theLevel);
    }
}

