/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.guice.FireDepartmentsProvider;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.NodeTypeConfig;
import io.druid.guice.PolyBind;
import io.druid.guice.RealtimeManagerConfig;
import io.druid.query.QuerySegmentWalker;
import io.druid.segment.realtime.DbSegmentPublisher;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.NoopSegmentPublisher;
import io.druid.segment.realtime.RealtimeManager;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.server.QueryResource;
import io.druid.server.initialization.JettyServerInitializer;
import java.util.List;
import org.eclipse.jetty.server.Server;

public class RealtimeModule
implements Module {
    public void configure(Binder binder) {
        PolyBind.createChoice((Binder)binder, (String)"druid.publish.type", (Key)Key.get(SegmentPublisher.class), (Key)Key.get(DbSegmentPublisher.class));
        MapBinder publisherBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(SegmentPublisher.class));
        publisherBinder.addBinding((Object)"noop").to(NoopSegmentPublisher.class);
        binder.bind(DbSegmentPublisher.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime", RealtimeManagerConfig.class);
        binder.bind((TypeLiteral)new TypeLiteral<List<FireDepartment>>(){}).toProvider(FireDepartmentsProvider.class).in(LazySingleton.class);
        binder.bind(QuerySegmentWalker.class).to(RealtimeManager.class).in(ManageLifecycle.class);
        binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig("realtime"));
        binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
        Jerseys.addResource((Binder)binder, QueryResource.class);
        LifecycleModule.register((Binder)binder, QueryResource.class);
        LifecycleModule.register((Binder)binder, Server.class);
    }
}

