/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.http.RedirectFilter;
import io.druid.server.initialization.JettyServerInitializer;
import javax.servlet.Filter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;

class CoordinatorJettyServerInitializer
implements JettyServerInitializer {
    CoordinatorJettyServerInitializer() {
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        root.addServlet(holderPwd, "/");
        root.setResourceBase(DruidCoordinator.class.getClassLoader().getResource("static").toExternalForm());
        root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
        root.addFilter(GzipFilter.class, "/*", null);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        root.addFilter(GuiceFilter.class, "/info/*", null);
        root.addFilter(GuiceFilter.class, "/druid/coordinator/*", null);
        root.addFilter(GuiceFilter.class, "/coordinator/*", null);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{root});
        server.setHandler((Handler)handlerList);
    }
}

