/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.MapBinder;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.druid.cli.GuiceRunnable;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.guice.Binders;
import io.druid.guice.IndexingServiceFirehoseModule;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.NodeTypeConfig;
import io.druid.guice.PolyBind;
import io.druid.indexing.common.RetryPolicyConfig;
import io.druid.indexing.common.RetryPolicyFactory;
import io.druid.indexing.common.TaskToolboxFactory;
import io.druid.indexing.common.actions.LocalTaskActionClientFactory;
import io.druid.indexing.common.actions.RemoteTaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.index.ChatHandlerProvider;
import io.druid.indexing.common.index.NoopChatHandlerProvider;
import io.druid.indexing.common.index.ServiceAnnouncingChatHandlerProvider;
import io.druid.indexing.overlord.HeapMemoryTaskStorage;
import io.druid.indexing.overlord.IndexerDBCoordinator;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.ThreadPoolTaskRunner;
import io.druid.indexing.worker.executor.ChatHandlerResource;
import io.druid.indexing.worker.executor.ExecutorLifecycle;
import io.druid.indexing.worker.executor.ExecutorLifecycleConfig;
import io.druid.query.QuerySegmentWalker;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.OmniDataSegmentArchiver;
import io.druid.segment.loading.OmniDataSegmentKiller;
import io.druid.segment.loading.OmniDataSegmentMover;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.segment.loading.StorageLocationConfig;
import io.druid.server.QueryResource;
import io.druid.server.initialization.JettyServerInitializer;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="peon", description="Runs a Peon, this is an individual forked \"task\" used as part of the indexing service. This should rarely, if ever, be used directly.")
public class CliPeon
extends GuiceRunnable {
    @Arguments(description="task.json status.json", required=true)
    public List<String> taskAndStatusFile;
    @Option(name={"--nodeType"}, title="nodeType", description="Set the node type to expose on ZK")
    public String nodeType = "indexer-executor";
    private static final Logger log = new Logger(CliPeon.class);

    public CliPeon() {
        super(log);
    }

    @Override
    protected List<Object> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.chathandler.type", (Key)Key.get(ChatHandlerProvider.class), (Key)Key.get(NoopChatHandlerProvider.class));
                MapBinder handlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ChatHandlerProvider.class));
                handlerProviderBinder.addBinding((Object)"announce").to(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
                handlerProviderBinder.addBinding((Object)"noop").to(NoopChatHandlerProvider.class).in(LazySingleton.class);
                binder.bind(TaskToolboxFactory.class).in(LazySingleton.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.peon.taskActionClient.retry", RetryPolicyConfig.class);
                this.configureTaskActionClient(binder);
                binder.bind(RetryPolicyFactory.class).in(LazySingleton.class);
                Binders.dataSegmentKillerBinder((Binder)binder);
                binder.bind(DataSegmentKiller.class).to(OmniDataSegmentKiller.class).in(LazySingleton.class);
                Binders.dataSegmentMoverBinder((Binder)binder);
                binder.bind(DataSegmentMover.class).to(OmniDataSegmentMover.class).in(LazySingleton.class);
                Binders.dataSegmentArchiverBinder((Binder)binder);
                binder.bind(DataSegmentArchiver.class).to(OmniDataSegmentArchiver.class).in(LazySingleton.class);
                binder.bind(ExecutorLifecycle.class).in(ManageLifecycle.class);
                binder.bind(ExecutorLifecycleConfig.class).toInstance((Object)new ExecutorLifecycleConfig().setTaskFile(new File(CliPeon.this.taskAndStatusFile.get(0))).setStatusFile(new File(CliPeon.this.taskAndStatusFile.get(1))));
                binder.bind(TaskRunner.class).to(ThreadPoolTaskRunner.class);
                binder.bind(QuerySegmentWalker.class).to(ThreadPoolTaskRunner.class);
                binder.bind(ThreadPoolTaskRunner.class).in(ManageLifecycle.class);
                binder.bind(SegmentLoaderConfig.class).toInstance((Object)new SegmentLoaderConfig().withLocations(Arrays.asList(new StorageLocationConfig[0])));
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, QueryResource.class);
                Jerseys.addResource((Binder)binder, ChatHandlerResource.class);
                LifecycleModule.register((Binder)binder, QueryResource.class);
                binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig(CliPeon.this.nodeType));
                LifecycleModule.register((Binder)binder, Server.class);
            }

            private void configureTaskActionClient(Binder binder) {
                PolyBind.createChoice((Binder)binder, (String)"druid.peon.mode", (Key)Key.get(TaskActionClientFactory.class), (Key)Key.get(RemoteTaskActionClientFactory.class));
                MapBinder taskActionBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskActionClientFactory.class));
                taskActionBinder.addBinding((Object)"local").to(LocalTaskActionClientFactory.class).in(LazySingleton.class);
                binder.bind(TaskStorage.class).to(HeapMemoryTaskStorage.class).in(LazySingleton.class);
                binder.bind(TaskActionToolbox.class).in(LazySingleton.class);
                binder.bind(IndexerDBCoordinator.class).in(LazySingleton.class);
                taskActionBinder.addBinding((Object)"remote").to(RemoteTaskActionClientFactory.class).in(LazySingleton.class);
            }
        }, (Object)new IndexingServiceFirehoseModule());
    }

    @Override
    public void run() {
        try {
            Injector injector = this.makeInjector();
            try {
                Lifecycle lifecycle = this.initLifecycle(injector);
                ((ExecutorLifecycle)injector.getInstance(ExecutorLifecycle.class)).join();
                lifecycle.stop();
            }
            catch (Throwable t) {
                log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

