/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.util.Providers;
import com.metamx.common.logger.Logger;
import io.airlift.command.Command;
import io.druid.cli.ServerRunnable;
import io.druid.guice.IndexingServiceFirehoseModule;
import io.druid.guice.IndexingServiceModuleHelper;
import io.druid.guice.IndexingServiceTaskLogsModule;
import io.druid.guice.JacksonConfigProvider;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ListProvider;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.PolyBind;
import io.druid.indexing.common.actions.LocalTaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.config.TaskStorageConfig;
import io.druid.indexing.common.index.ChatHandlerProvider;
import io.druid.indexing.common.tasklogs.SwitchingTaskLogStreamer;
import io.druid.indexing.common.tasklogs.TaskRunnerTaskLogStreamer;
import io.druid.indexing.overlord.DbTaskStorage;
import io.druid.indexing.overlord.ForkingTaskRunnerFactory;
import io.druid.indexing.overlord.HeapMemoryTaskStorage;
import io.druid.indexing.overlord.IndexerDBCoordinator;
import io.druid.indexing.overlord.RemoteTaskRunnerFactory;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.indexing.overlord.config.TaskQueueConfig;
import io.druid.indexing.overlord.http.OverlordRedirectInfo;
import io.druid.indexing.overlord.http.OverlordResource;
import io.druid.indexing.overlord.scaling.AutoScalingStrategy;
import io.druid.indexing.overlord.scaling.EC2AutoScalingStrategy;
import io.druid.indexing.overlord.scaling.NoopAutoScalingStrategy;
import io.druid.indexing.overlord.scaling.ResourceManagementSchedulerConfig;
import io.druid.indexing.overlord.scaling.ResourceManagementSchedulerFactory;
import io.druid.indexing.overlord.scaling.ResourceManagementSchedulerFactoryImpl;
import io.druid.indexing.overlord.scaling.ResourceManagementStrategy;
import io.druid.indexing.overlord.scaling.SimpleResourceManagementConfig;
import io.druid.indexing.overlord.scaling.SimpleResourceManagementStrategy;
import io.druid.indexing.overlord.setup.WorkerSetupData;
import io.druid.indexing.worker.config.WorkerConfig;
import io.druid.server.http.RedirectFilter;
import io.druid.server.http.RedirectInfo;
import io.druid.server.initialization.JettyServerInitializer;
import io.druid.tasklogs.TaskLogStreamer;
import io.druid.tasklogs.TaskLogs;
import java.util.List;
import javax.servlet.Filter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

@Command(name="overlord", description="Runs an Overlord node, see http://druid.io/docs/0.6.58/Indexing-Service.html for a description")
public class CliOverlord
extends ServerRunnable {
    private static Logger log = new Logger(CliOverlord.class);

    public CliOverlord() {
        super(log);
    }

    @Override
    protected List<Object> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.queue", TaskQueueConfig.class);
                binder.bind(TaskMaster.class).in(ManageLifecycle.class);
                binder.bind(TaskLogStreamer.class).to(SwitchingTaskLogStreamer.class).in(LazySingleton.class);
                binder.bind((TypeLiteral)new TypeLiteral<List<TaskLogStreamer>>(){}).toProvider((Provider)new ListProvider().add(TaskRunnerTaskLogStreamer.class).add(TaskLogs.class)).in(LazySingleton.class);
                binder.bind(TaskActionClientFactory.class).to(LocalTaskActionClientFactory.class).in(LazySingleton.class);
                binder.bind(TaskActionToolbox.class).in(LazySingleton.class);
                binder.bind(IndexerDBCoordinator.class).in(LazySingleton.class);
                binder.bind(TaskLockbox.class).in(LazySingleton.class);
                binder.bind(TaskStorageQueryAdapter.class).in(LazySingleton.class);
                binder.bind(ResourceManagementSchedulerFactory.class).to(ResourceManagementSchedulerFactoryImpl.class).in(LazySingleton.class);
                binder.bind(ChatHandlerProvider.class).toProvider(Providers.of(null));
                this.configureTaskStorage(binder);
                this.configureRunners(binder);
                this.configureAutoscale(binder);
                binder.bind(RedirectFilter.class).in(LazySingleton.class);
                binder.bind(RedirectInfo.class).to(OverlordRedirectInfo.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).toInstance((Object)new OverlordJettyServerInitializer());
                Jerseys.addResource((Binder)binder, OverlordResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
            }

            private void configureTaskStorage(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.storage", TaskStorageConfig.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.storage.type", (Key)Key.get(TaskStorage.class), (Key)Key.get(HeapMemoryTaskStorage.class));
                MapBinder storageBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskStorage.class));
                storageBinder.addBinding((Object)"local").to(HeapMemoryTaskStorage.class);
                binder.bind(HeapMemoryTaskStorage.class).in(LazySingleton.class);
                storageBinder.addBinding((Object)"db").to(DbTaskStorage.class).in(ManageLifecycle.class);
                binder.bind(DbTaskStorage.class).in(LazySingleton.class);
            }

            private void configureRunners(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.worker", WorkerConfig.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.runner.type", (Key)Key.get(TaskRunnerFactory.class), (Key)Key.get(ForkingTaskRunnerFactory.class));
                MapBinder biddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskRunnerFactory.class));
                IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder);
                biddy.addBinding((Object)"local").to(ForkingTaskRunnerFactory.class);
                binder.bind(ForkingTaskRunnerFactory.class).in(LazySingleton.class);
                biddy.addBinding((Object)"remote").to(RemoteTaskRunnerFactory.class).in(LazySingleton.class);
                binder.bind(RemoteTaskRunnerFactory.class).in(LazySingleton.class);
            }

            private void configureAutoscale(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", ResourceManagementSchedulerConfig.class);
                binder.bind(ResourceManagementStrategy.class).to(SimpleResourceManagementStrategy.class).in(LazySingleton.class);
                JacksonConfigProvider.bind((Binder)binder, (String)"worker.setup", WorkerSetupData.class, null);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.autoscale.strategy", (Key)Key.get(AutoScalingStrategy.class), (Key)Key.get(NoopAutoScalingStrategy.class));
                MapBinder autoScalingBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(AutoScalingStrategy.class));
                autoScalingBinder.addBinding((Object)"ec2").to(EC2AutoScalingStrategy.class);
                binder.bind(EC2AutoScalingStrategy.class).in(LazySingleton.class);
                autoScalingBinder.addBinding((Object)"noop").to(NoopAutoScalingStrategy.class);
                binder.bind(NoopAutoScalingStrategy.class).in(LazySingleton.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", SimpleResourceManagementConfig.class);
            }
        }, (Object)new IndexingServiceFirehoseModule(), (Object)new IndexingServiceTaskLogsModule());
    }

    private static class OverlordJettyServerInitializer
    implements JettyServerInitializer {
        private OverlordJettyServerInitializer() {
        }

        public void initialize(Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
            root.addServlet(holderPwd, "/");
            root.setBaseResource((Resource)new ResourceCollection(new String[]{TaskMaster.class.getClassLoader().getResource("static").toExternalForm(), TaskMaster.class.getClassLoader().getResource("indexer_static").toExternalForm()}));
            root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
            root.addFilter(GzipFilter.class, "/*", null);
            root.addFilter(GuiceFilter.class, "/status/*", null);
            root.addFilter(GuiceFilter.class, "/druid/*", null);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{root});
            server.setHandler((Handler)handlerList);
        }
    }
}

