/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.metamx.common.logger.Logger;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.druid.cli.CliHadoopIndexer;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerConfigBuilder;
import io.druid.indexer.HadoopDruidIndexerJob;
import java.io.File;

@Command(name="hadoop-indexer", description="Runs the batch Hadoop Druid Indexer, see https://github.com/metamx/druid/wiki/Batch-ingestion for a description.")
public class CliInternalHadoopIndexer
implements Runnable {
    @Arguments(description="A JSON object or the path to a file that contains a JSON object", required=true)
    private String argumentSpec;
    private static final Logger log = new Logger(CliHadoopIndexer.class);

    @Override
    public void run() {
        try {
            HadoopDruidIndexerJob job = new HadoopDruidIndexerJob(this.getHadoopDruidIndexerConfig());
            job.run();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HadoopDruidIndexerConfig getHadoopDruidIndexerConfig() {
        try {
            if (this.argumentSpec.startsWith("{")) {
                return HadoopDruidIndexerConfigBuilder.fromString((String)this.argumentSpec);
            }
            return HadoopDruidIndexerConfigBuilder.fromFile((File)new File(this.argumentSpec));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

