/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.metamx.common.logger.Logger;
import io.airlift.command.Command;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.guice.Jerseys;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.NodeTypeConfig;
import io.druid.query.QuerySegmentWalker;
import io.druid.server.QueryResource;
import io.druid.server.coordination.ServerManager;
import io.druid.server.coordination.ZkCoordinator;
import io.druid.server.initialization.JettyServerInitializer;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="historical", description="Runs a Historical node, see http://druid.io/docs/0.6.58/Historical.html for a description")
public class CliHistorical
extends ServerRunnable {
    private static final Logger log = new Logger(CliHistorical.class);

    public CliHistorical() {
        super(log);
    }

    @Override
    protected List<Object> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(ServerManager.class).in(LazySingleton.class);
                binder.bind(ZkCoordinator.class).in(ManageLifecycle.class);
                binder.bind(QuerySegmentWalker.class).to(ServerManager.class).in(LazySingleton.class);
                binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig("historical"));
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, QueryResource.class);
                LifecycleModule.register((Binder)binder, QueryResource.class);
                LifecycleModule.register((Binder)binder, ZkCoordinator.class);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        });
    }
}

