/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.metamx.common.logger.Logger;
import io.airlift.command.Command;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.client.BrokerServerView;
import io.druid.client.CachingClusteredClient;
import io.druid.client.TimelineServerView;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheMonitor;
import io.druid.client.cache.CacheProvider;
import io.druid.client.selector.ServerSelectorStrategy;
import io.druid.curator.discovery.DiscoveryModule;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.query.MapQueryToolChestWarehouse;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.server.ClientInfoResource;
import io.druid.server.ClientQuerySegmentWalker;
import io.druid.server.QueryResource;
import io.druid.server.initialization.JettyServerInitializer;
import io.druid.server.metrics.MetricsModule;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="broker", description="Runs a broker node, see http://druid.io/docs/0.6.58/Broker.html for a description")
public class CliBroker
extends ServerRunnable {
    private static final Logger log = new Logger(CliBroker.class);

    public CliBroker() {
        super(log);
    }

    @Override
    protected List<Object> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(QueryToolChestWarehouse.class).to(MapQueryToolChestWarehouse.class);
                binder.bind(CachingClusteredClient.class).in(LazySingleton.class);
                binder.bind(TimelineServerView.class).to(BrokerServerView.class).in(LazySingleton.class);
                binder.bind(Cache.class).toProvider(CacheProvider.class).in(ManageLifecycle.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.cache", CacheProvider.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.balancer", ServerSelectorStrategy.class);
                binder.bind(QuerySegmentWalker.class).to(ClientQuerySegmentWalker.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, QueryResource.class);
                Jerseys.addResource((Binder)binder, ClientInfoResource.class);
                LifecycleModule.register((Binder)binder, QueryResource.class);
                DiscoveryModule.register((Binder)binder, Self.class);
                MetricsModule.register((Binder)binder, CacheMonitor.class);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        });
    }
}

