/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.CompressedFloatsIndexedSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.FloatGenericColumnSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class FloatGenericColumnPartSerde
implements ColumnPartSerde {
    private final CompressedFloatsIndexedSupplier compressedFloats;
    private final ByteOrder byteOrder;

    @JsonCreator
    public static FloatGenericColumnPartSerde createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new FloatGenericColumnPartSerde(null, byteOrder);
    }

    public FloatGenericColumnPartSerde(CompressedFloatsIndexedSupplier compressedFloats, ByteOrder byteOrder) {
        this.compressedFloats = compressedFloats;
        this.byteOrder = byteOrder;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public long numBytes() {
        return this.compressedFloats.getSerializedSize();
    }

    @Override
    public void write(WritableByteChannel channel) throws IOException {
        this.compressedFloats.writeToChannel(channel);
    }

    @Override
    public ColumnPartSerde read(ByteBuffer buffer, ColumnBuilder builder) {
        CompressedFloatsIndexedSupplier column = CompressedFloatsIndexedSupplier.fromByteBuffer(buffer, this.byteOrder);
        builder.setType(ValueType.FLOAT).setHasMultipleValues(false).setGenericColumn(new FloatGenericColumnSupplier(column, this.byteOrder));
        return new FloatGenericColumnPartSerde(column, this.byteOrder);
    }
}

