/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.google.common.base.Supplier;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.data.GenericIndexed;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;

public class BitmapIndexColumnPartSupplier
implements Supplier<BitmapIndex> {
    private static final ImmutableConciseSet EMPTY_SET = new ImmutableConciseSet();
    private final GenericIndexed<ImmutableConciseSet> bitmaps;
    private final GenericIndexed<String> dictionary;

    public BitmapIndexColumnPartSupplier(GenericIndexed<ImmutableConciseSet> bitmaps, GenericIndexed<String> dictionary) {
        this.bitmaps = bitmaps;
        this.dictionary = dictionary;
    }

    public BitmapIndex get() {
        return new BitmapIndex(){

            @Override
            public int getCardinality() {
                return BitmapIndexColumnPartSupplier.this.dictionary.size();
            }

            @Override
            public String getValue(int index) {
                return (String)BitmapIndexColumnPartSupplier.this.dictionary.get(index);
            }

            @Override
            public boolean hasNulls() {
                return BitmapIndexColumnPartSupplier.this.dictionary.indexOf(null) >= 0;
            }

            @Override
            public ImmutableConciseSet getConciseSet(String value) {
                int index = BitmapIndexColumnPartSupplier.this.dictionary.indexOf(value);
                return this.getConciseSet(index);
            }

            @Override
            public ImmutableConciseSet getConciseSet(int idx) {
                if (idx < 0) {
                    return EMPTY_SET;
                }
                ImmutableConciseSet bitmap = (ImmutableConciseSet)BitmapIndexColumnPartSupplier.this.bitmaps.get(idx);
                return bitmap == null ? EMPTY_SET : bitmap;
            }
        };
    }
}

