/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Floats;
import com.metamx.common.ISE;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.SpatialDimensionSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SpatialDimensionRowFormatter {
    private static final Joiner JOINER = Joiner.on((String)",");
    private static final Splitter SPLITTER = Splitter.on((String)",");
    private final List<SpatialDimensionSchema> spatialDimensions;
    private final Set<String> spatialDimNames;
    private final Set<String> spatialPartialDimNames;

    public SpatialDimensionRowFormatter(List<SpatialDimensionSchema> spatialDimensions) {
        this.spatialDimensions = spatialDimensions;
        this.spatialDimNames = Sets.newHashSet((Iterable)Lists.transform(spatialDimensions, (Function)new Function<SpatialDimensionSchema, String>(){

            public String apply(SpatialDimensionSchema input) {
                return input.getDimName();
            }
        }));
        this.spatialPartialDimNames = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Lists.transform(spatialDimensions, (Function)new Function<SpatialDimensionSchema, List<String>>(){

            public List<String> apply(SpatialDimensionSchema input) {
                return input.getDims();
            }
        })));
    }

    public InputRow formatRow(final InputRow row) {
        final HashMap spatialLookup = Maps.newHashMap();
        final ArrayList finalDims = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Lists.transform((List)row.getDimensions(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return input.toLowerCase();
            }
        }), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !SpatialDimensionRowFormatter.this.spatialDimNames.contains(input) && !SpatialDimensionRowFormatter.this.spatialPartialDimNames.contains(input);
            }
        }));
        InputRow retVal = new InputRow(){

            public List<String> getDimensions() {
                return finalDims;
            }

            public long getTimestampFromEpoch() {
                return row.getTimestampFromEpoch();
            }

            public List<String> getDimension(String dimension) {
                List retVal = (List)spatialLookup.get(dimension);
                return retVal == null ? row.getDimension(dimension) : retVal;
            }

            public Object getRaw(String dimension) {
                return row.getRaw(dimension);
            }

            public float getFloatMetric(String metric) {
                return row.getFloatMetric(metric);
            }

            public String toString() {
                return row.toString();
            }
        };
        if (!this.spatialPartialDimNames.isEmpty()) {
            for (SpatialDimensionSchema spatialDimension : this.spatialDimensions) {
                ArrayList spatialDimVals = Lists.newArrayList();
                for (String partialSpatialDim : spatialDimension.getDims()) {
                    List dimVals = row.getDimension(partialSpatialDim);
                    if (!this.isSpatialDimValsValid(dimVals)) continue;
                    spatialDimVals.addAll(dimVals);
                }
                if (spatialDimVals.size() != this.spatialPartialDimNames.size()) continue;
                spatialLookup.put(spatialDimension.getDimName(), Arrays.asList(JOINER.join((Iterable)spatialDimVals)));
                finalDims.add(spatialDimension.getDimName());
            }
        } else {
            for (String spatialDimName : this.spatialDimNames) {
                List dimVals = row.getDimension(spatialDimName);
                if (dimVals.size() != 1) {
                    throw new ISE("Cannot have a spatial dimension value with size[%d]", new Object[]{dimVals.size()});
                }
                if (!this.isJoinedSpatialDimValValid((String)dimVals.get(0))) continue;
                spatialLookup.put(spatialDimName, dimVals);
                finalDims.add(spatialDimName);
            }
        }
        return retVal;
    }

    private boolean isSpatialDimValsValid(List<String> dimVals) {
        if (dimVals == null || dimVals.isEmpty()) {
            return false;
        }
        for (String dimVal : dimVals) {
            if (Floats.tryParse((String)dimVal) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isJoinedSpatialDimValValid(String dimVal) {
        if (dimVal == null || dimVal.isEmpty()) {
            return false;
        }
        Iterable dimVals = SPLITTER.split((CharSequence)dimVal);
        for (String val : dimVals) {
            if (Floats.tryParse((String)val) != null) continue;
            return false;
        }
        return true;
    }
}

