/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.metamx.collections.spatial.search.Bound;
import com.metamx.common.guava.FunctionalIterator;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.StorageAdapter;
import io.druid.segment.TimestampColumnSelector;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.ListIndexed;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IncrementalIndexStorageAdapter
implements StorageAdapter {
    private static final Splitter SPLITTER = Splitter.on((String)",");
    private final IncrementalIndex index;

    public IncrementalIndexStorageAdapter(IncrementalIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.index.getDimensions(), String.class);
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.index.getMetricNames();
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        IncrementalIndex.DimDim dimDim = this.index.getDimension(dimension.toLowerCase());
        if (dimDim == null) {
            return 0;
        }
        return dimDim.size();
    }

    @Override
    public DateTime getMinTime() {
        return this.index.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.index.getMaxTime();
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(false).build();
    }

    @Override
    public Iterable<Cursor> makeCursors(final Filter filter, Interval interval, final QueryGranularity gran) {
        Interval actualIntervalTmp = interval;
        Interval dataInterval = new Interval(this.getMinTime().getMillis(), gran.next(this.getMaxTime().getMillis()));
        if (!actualIntervalTmp.overlaps((ReadableInterval)dataInterval)) {
            return ImmutableList.of();
        }
        if (actualIntervalTmp.getStart().isBefore((ReadableInstant)dataInterval.getStart())) {
            actualIntervalTmp = actualIntervalTmp.withStart((ReadableInstant)dataInterval.getStart());
        }
        if (actualIntervalTmp.getEnd().isAfter((ReadableInstant)dataInterval.getEnd())) {
            actualIntervalTmp = actualIntervalTmp.withEnd((ReadableInstant)dataInterval.getEnd());
        }
        final Interval actualInterval = actualIntervalTmp;
        return new Iterable<Cursor>(){

            @Override
            public Iterator<Cursor> iterator() {
                return FunctionalIterator.create(gran.iterable(actualInterval.getStartMillis(), actualInterval.getEndMillis()).iterator()).transform((Function)new Function<Long, Cursor>(){
                    EntryHolder currEntry = new EntryHolder();
                    private final ValueMatcher filterMatcher;
                    {
                        this.filterMatcher = IncrementalIndexStorageAdapter.this.makeFilterMatcher(filter, this.currEntry);
                    }

                    public Cursor apply(final @Nullable Long input) {
                        final long timeStart = Math.max(input, actualInterval.getStartMillis());
                        return new Cursor(){
                            private Iterator<Map.Entry<IncrementalIndex.TimeAndDims, Aggregator[]>> baseIter;
                            private ConcurrentNavigableMap<IncrementalIndex.TimeAndDims, Aggregator[]> cursorMap;
                            final DateTime time;
                            int numAdvanced = -1;
                            boolean done;
                            {
                                this.cursorMap = IncrementalIndexStorageAdapter.this.index.getSubMap(new IncrementalIndex.TimeAndDims(timeStart, new String[0][]), new IncrementalIndex.TimeAndDims(Math.min(actualInterval.getEndMillis(), gran.next(input)), new String[0][]));
                                this.time = gran.toDateTime(input);
                                this.reset();
                            }

                            @Override
                            public DateTime getTime() {
                                return this.time;
                            }

                            @Override
                            public void advance() {
                                if (!this.baseIter.hasNext()) {
                                    this.done = true;
                                    return;
                                }
                                while (this.baseIter.hasNext()) {
                                    currEntry.set(this.baseIter.next());
                                    if (!filterMatcher.matches()) continue;
                                    return;
                                }
                                if (!filterMatcher.matches()) {
                                    this.done = true;
                                }
                            }

                            @Override
                            public void advanceTo(int offset) {
                                for (int count = 0; count < offset && !this.isDone(); ++count) {
                                    this.advance();
                                }
                            }

                            @Override
                            public boolean isDone() {
                                return this.done;
                            }

                            @Override
                            public void reset() {
                                this.baseIter = this.cursorMap.entrySet().iterator();
                                if (this.numAdvanced == -1) {
                                    this.numAdvanced = 0;
                                    while (this.baseIter.hasNext()) {
                                        currEntry.set(this.baseIter.next());
                                        if (filterMatcher.matches()) {
                                            return;
                                        }
                                        ++this.numAdvanced;
                                    }
                                } else {
                                    Iterators.advance(this.baseIter, (int)this.numAdvanced);
                                    if (this.baseIter.hasNext()) {
                                        currEntry.set(this.baseIter.next());
                                    }
                                }
                                this.done = this.cursorMap.size() == 0 || !this.baseIter.hasNext();
                            }

                            @Override
                            public TimestampColumnSelector makeTimestampColumnSelector() {
                                return new TimestampColumnSelector(){

                                    @Override
                                    public long getTimestamp() {
                                        return currEntry.getKey().getTimestamp();
                                    }
                                };
                            }

                            @Override
                            public DimensionSelector makeDimensionSelector(String dimension) {
                                String dimensionName = dimension.toLowerCase();
                                final IncrementalIndex.DimDim dimValLookup = IncrementalIndexStorageAdapter.this.index.getDimension(dimensionName);
                                if (dimValLookup == null) {
                                    return null;
                                }
                                final int maxId = dimValLookup.size();
                                final int dimIndex = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimensionName);
                                return new DimensionSelector(){

                                    @Override
                                    public IndexedInts getRow() {
                                        String[] dimVals;
                                        final ArrayList vals = Lists.newArrayList();
                                        if (dimIndex < currEntry.getKey().getDims().length && (dimVals = currEntry.getKey().getDims()[dimIndex]) != null) {
                                            for (String dimVal : dimVals) {
                                                int id = dimValLookup.getId(dimVal);
                                                if (id >= maxId) continue;
                                                vals.add(id);
                                            }
                                        }
                                        return new IndexedInts(){

                                            @Override
                                            public int size() {
                                                return vals.size();
                                            }

                                            @Override
                                            public int get(int index) {
                                                return (Integer)vals.get(index);
                                            }

                                            @Override
                                            public Iterator<Integer> iterator() {
                                                return vals.iterator();
                                            }
                                        };
                                    }

                                    @Override
                                    public int getValueCardinality() {
                                        return maxId;
                                    }

                                    @Override
                                    public String lookupName(int id) {
                                        return dimValLookup.getValue(id);
                                    }

                                    @Override
                                    public int lookupId(String name) {
                                        return dimValLookup.getId(name);
                                    }
                                };
                            }

                            @Override
                            public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                                String metricName = columnName.toLowerCase();
                                Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(metricName);
                                if (metricIndexInt == null) {
                                    return new FloatColumnSelector(){

                                        @Override
                                        public float get() {
                                            return 0.0f;
                                        }
                                    };
                                }
                                final int metricIndex = metricIndexInt;
                                return new FloatColumnSelector(){

                                    @Override
                                    public float get() {
                                        return currEntry.getValue()[metricIndex].getFloat();
                                    }
                                };
                            }

                            @Override
                            public ObjectColumnSelector makeObjectColumnSelector(String column) {
                                String columnName = column.toLowerCase();
                                Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(columnName);
                                if (metricIndexInt != null) {
                                    final int metricIndex = metricIndexInt;
                                    final ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(IncrementalIndexStorageAdapter.this.index.getMetricType(columnName));
                                    return new ObjectColumnSelector(){

                                        public Class classOfObject() {
                                            return serde.getObjectStrategy().getClazz();
                                        }

                                        public Object get() {
                                            return currEntry.getValue()[metricIndex].get();
                                        }
                                    };
                                }
                                Integer dimensionIndexInt = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(columnName);
                                if (dimensionIndexInt != null) {
                                    final int dimensionIndex = dimensionIndexInt;
                                    return new ObjectColumnSelector<String>(){

                                        @Override
                                        public Class classOfObject() {
                                            return String.class;
                                        }

                                        @Override
                                        public String get() {
                                            String[] dimVals = currEntry.getKey().getDims()[dimensionIndex];
                                            if (dimVals.length == 1) {
                                                return dimVals[0];
                                            }
                                            if (dimVals.length == 0) {
                                                return null;
                                            }
                                            throw new UnsupportedOperationException("makeObjectColumnSelector does not support multivalued columns");
                                        }
                                    };
                                }
                                return null;
                            }
                        };
                    }
                });
            }
        };
    }

    private ValueMatcher makeFilterMatcher(Filter filter, EntryHolder holder) {
        return filter == null ? new BooleanValueMatcher(true) : filter.makeMatcher(new EntryHolderValueMatcherFactory(holder));
    }

    private class EntryHolderValueMatcherFactory
    implements ValueMatcherFactory {
        private final EntryHolder holder;

        public EntryHolderValueMatcherFactory(EntryHolder holder) {
            this.holder = holder;
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, String value) {
            Integer dimIndexObject = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimension.toLowerCase());
            if (dimIndexObject == null) {
                return new BooleanValueMatcher(false);
            }
            String idObject = IncrementalIndexStorageAdapter.this.index.getDimension(dimension.toLowerCase()).get(value);
            if (idObject == null) {
                if (value == null || "".equals(value)) {
                    final int dimIndex = dimIndexObject;
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                            return dimIndex >= dims.length || dims[dimIndex] == null;
                        }
                    };
                }
                return new BooleanValueMatcher(false);
            }
            final int dimIndex = dimIndexObject;
            final String id = idObject;
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                    if (dimIndex >= dims.length || dims[dimIndex] == null) {
                        return false;
                    }
                    for (String dimVal : dims[dimIndex]) {
                        if (id != dimVal) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, final Predicate<String> predicate) {
            Integer dimIndexObject = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimension.toLowerCase());
            if (dimIndexObject == null) {
                return new BooleanValueMatcher(false);
            }
            final int dimIndex = dimIndexObject;
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                    if (dimIndex >= dims.length || dims[dimIndex] == null) {
                        return false;
                    }
                    for (String dimVal : dims[dimIndex]) {
                        if (!predicate.apply((Object)dimVal)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, final Bound bound) {
            if (!dimension.endsWith(".geo")) {
                return new BooleanValueMatcher(false);
            }
            Integer dimIndexObject = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimension.toLowerCase());
            if (dimIndexObject == null) {
                return new BooleanValueMatcher(false);
            }
            final int dimIndex = dimIndexObject;
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                    if (dimIndex >= dims.length || dims[dimIndex] == null) {
                        return false;
                    }
                    for (String dimVal : dims[dimIndex]) {
                        ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                        float[] coords = new float[stringCoords.size()];
                        for (int j = 0; j < coords.length; ++j) {
                            coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                        }
                        if (!bound.contains(coords)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    private static class EntryHolder {
        Map.Entry<IncrementalIndex.TimeAndDims, Aggregator[]> currEntry = null;

        private EntryHolder() {
        }

        public Map.Entry<IncrementalIndex.TimeAndDims, Aggregator[]> get() {
            return this.currEntry;
        }

        public void set(Map.Entry<IncrementalIndex.TimeAndDims, Aggregator[]> currEntry) {
            this.currEntry = currEntry;
            this.currEntry = currEntry;
        }

        public IncrementalIndex.TimeAndDims getKey() {
            return this.currEntry.getKey();
        }

        public Aggregator[] getValue() {
            return this.currEntry.getValue();
        }
    }
}

