/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import java.util.Collections;
import java.util.List;

public class IncrementalIndexSchema {
    private final long minTimestamp;
    private final QueryGranularity gran;
    private final List<String> dimensions;
    private final List<SpatialDimensionSchema> spatialDimensions;
    private final AggregatorFactory[] metrics;

    public IncrementalIndexSchema(long minTimestamp, QueryGranularity gran, List<String> dimensions, List<SpatialDimensionSchema> spatialDimensions, AggregatorFactory[] metrics) {
        this.minTimestamp = minTimestamp;
        this.gran = gran;
        this.dimensions = dimensions;
        this.spatialDimensions = spatialDimensions;
        this.metrics = metrics;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public QueryGranularity getGran() {
        return this.gran;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }

    public AggregatorFactory[] getMetrics() {
        return this.metrics;
    }

    public static class Builder {
        private long minTimestamp = 0L;
        private QueryGranularity gran = QueryGranularity.NONE;
        private List<String> dimensions = Lists.newArrayList();
        private List<SpatialDimensionSchema> spatialDimensions = Lists.newArrayList();
        private AggregatorFactory[] metrics = new AggregatorFactory[0];

        public Builder withMinTimestamp(long minTimestamp) {
            this.minTimestamp = minTimestamp;
            return this;
        }

        public Builder withQueryGranularity(QueryGranularity gran) {
            this.gran = gran;
            return this;
        }

        public Builder withDimensions(Iterable<String> dimensions) {
            this.dimensions = Lists.newArrayList((Iterable)Iterables.transform(dimensions, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.toLowerCase();
                }
            }));
            Collections.sort(this.dimensions);
            return this;
        }

        public Builder withSpatialDimensions(List<SpatialDimensionSchema> spatialDimensions) {
            this.spatialDimensions = spatialDimensions;
            return this;
        }

        public Builder withMetrics(AggregatorFactory[] metrics) {
            this.metrics = metrics;
            return this;
        }

        public IncrementalIndexSchema build() {
            return new IncrementalIndexSchema(this.minTimestamp, this.gran, this.dimensions, this.spatialDimensions, this.metrics);
        }
    }
}

