/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.query.aggregation.Aggregator;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.data.EmptyIndexedInts;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.ListIndexed;
import io.druid.segment.incremental.IncrementalIndex;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class IncrementalIndexAdapter
implements IndexableAdapter {
    private static final Logger log = new Logger(IncrementalIndexAdapter.class);
    private final Interval dataInterval;
    private final IncrementalIndex index;
    private final Map<String, Map<String, ConciseSet>> invertedIndexes;

    public IncrementalIndexAdapter(Interval dataInterval, IncrementalIndex index) {
        this.dataInterval = dataInterval;
        this.index = index;
        this.invertedIndexes = Maps.newHashMap();
        for (String dimension : index.getDimensions()) {
            this.invertedIndexes.put(dimension, Maps.newHashMap());
        }
        int rowNum = 0;
        for (IncrementalIndex.TimeAndDims timeAndDims : index.getFacts().keySet()) {
            String[][] dims = timeAndDims.getDims();
            for (String dimension : index.getDimensions()) {
                int dimIndex = index.getDimensionIndex(dimension);
                Map<String, ConciseSet> conciseSets = this.invertedIndexes.get(dimension);
                if (conciseSets == null || dims == null) {
                    log.error("conciseSets and dims are null!", new Object[0]);
                    continue;
                }
                if (dimIndex >= dims.length || dims[dimIndex] == null) continue;
                for (String dimValue : dims[dimIndex]) {
                    ConciseSet conciseSet = conciseSets.get(dimValue);
                    if (conciseSet == null) {
                        conciseSet = new ConciseSet();
                        conciseSets.put(dimValue, conciseSet);
                    }
                    try {
                        conciseSet.add(rowNum);
                    }
                    catch (Exception e) {
                        log.info(e.toString(), new Object[0]);
                    }
                }
            }
            ++rowNum;
        }
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.index.size();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.index.getDimensions(), String.class);
    }

    @Override
    public Indexed<String> getAvailableMetrics() {
        return new ListIndexed<String>(this.index.getMetricNames(), String.class);
    }

    @Override
    public Indexed<String> getDimValueLookup(String dimension) {
        final IncrementalIndex.DimDim dimDim = this.index.getDimension(dimension);
        dimDim.sort();
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return dimDim.size();
            }

            @Override
            public String get(int index) {
                return dimDim.getSortedValue(index);
            }

            @Override
            public int indexOf(String value) {
                return dimDim.getSortedId(value);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }
        };
    }

    @Override
    public Iterable<Rowboat> getRows() {
        return FunctionalIterable.create(this.index.getFacts().entrySet()).transform((Function)new Function<Map.Entry<IncrementalIndex.TimeAndDims, Aggregator[]>, Rowboat>(){
            int count = 0;

            public Rowboat apply(@Nullable Map.Entry<IncrementalIndex.TimeAndDims, Aggregator[]> input) {
                IncrementalIndex.TimeAndDims timeAndDims = input.getKey();
                String[][] dimValues = timeAndDims.getDims();
                Aggregator[] aggs = input.getValue();
                int[][] dims = new int[dimValues.length][];
                for (String dimension : IncrementalIndexAdapter.this.index.getDimensions()) {
                    int dimIndex = IncrementalIndexAdapter.this.index.getDimensionIndex(dimension);
                    IncrementalIndex.DimDim dimDim = IncrementalIndexAdapter.this.index.getDimension(dimension);
                    dimDim.sort();
                    if (dimIndex >= dimValues.length || dimValues[dimIndex] == null) continue;
                    dims[dimIndex] = new int[dimValues[dimIndex].length];
                    if (dimIndex >= dims.length || dims[dimIndex] == null) continue;
                    for (int i = 0; i < dimValues[dimIndex].length; ++i) {
                        dims[dimIndex][i] = dimDim.getSortedId(dimValues[dimIndex][i]);
                    }
                }
                Object[] metrics = new Object[aggs.length];
                for (int i = 0; i < aggs.length; ++i) {
                    metrics[i] = aggs[i].get();
                }
                HashMap description = Maps.newHashMap();
                for (SpatialDimensionSchema spatialDimensionSchema : IncrementalIndexAdapter.this.index.getSpatialDimensions()) {
                    description.put(spatialDimensionSchema.getDimName(), "spatial");
                }
                return new Rowboat(timeAndDims.getTimestamp(), dims, metrics, this.count++, description);
            }
        });
    }

    @Override
    public IndexedInts getInverteds(String dimension, String value) {
        Map<String, ConciseSet> dimInverted = this.invertedIndexes.get(dimension);
        if (dimInverted == null) {
            return new EmptyIndexedInts();
        }
        final ConciseSet conciseSet = dimInverted.get(value);
        if (conciseSet == null) {
            return new EmptyIndexedInts();
        }
        return new IndexedInts(){

            @Override
            public int size() {
                return conciseSet.size();
            }

            @Override
            public int get(int index) {
                throw new UnsupportedOperationException("This is really slow, so it's just not supported.");
            }

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    IntSet.IntIterator baseIter;
                    {
                        this.baseIter = conciseSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.baseIter.hasNext();
                    }

                    @Override
                    public Integer next() {
                        return this.baseIter.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public String getMetricType(String metric) {
        return this.index.getMetricType(metric);
    }
}

